package org.simantics.structural2.modelingRules;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.stubs.StructuralResource2;

public class StandardAttachmentRelationMap implements IAttachmentRelationMap {

	public final static StandardAttachmentRelationMap INSTANCE = 
		new StandardAttachmentRelationMap();
	
	@Override
	public Resource get(ReadGraph g, CPTerminal cp) throws DatabaseException {
		CPTerminal terminal = (CPTerminal)cp;
		StructuralResource2 sr = StructuralResource2.getInstance(g);
		return g.getPossibleObject(
				terminal.relation,
                sr.HasAttachmentRelation);
	}

}
