package org.simantics.structural2.internal.queries;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.queries.Terminal;
import org.simantics.structural2.utils.StructuralUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ConnectedTo extends ResourceRead2<Set<Terminal>> {

    private static final boolean DEBUG = false;

    public ConnectedTo(Resource component, Resource connectionPoint) {
        super(component, connectionPoint);
    }

    @Override
    public Set<Terminal> perform(ReadGraph graph) throws DatabaseException {
        if (DEBUG)
            System.out.println("connectedTo(" + NameUtils.getSafeName(graph, resource) + ", " + NameUtils.getSafeName(graph, resource2) + ")");

        Collection<Resource> connections = graph.getObjects(resource, resource2);
        if (connections.isEmpty())
            return Collections.emptySet();

        Set<Resource> reachableConnections = new HashSet<Resource>();
        for (Resource connection : connections) {
            reachableConnections.addAll(StructuralUtils.getRelatedConnections(graph, connection));
        }

        StructuralResource2 sr = StructuralResource2.getInstance(graph);

        Set<Terminal> connectedTo = new HashSet<Terminal>();

        for (Resource connection : reachableConnections) {
            if (DEBUG)
                System.out.println("  checking connection: " + NameUtils.getSafeName(graph, connection));

            for (Statement stm : graph.getStatements(connection, sr.Connects)) {
                Resource connectionPoint2 = graph.getInverse(stm.getPredicate());
                if (resource2.equals(connectionPoint2) && resource.equals(stm.getObject()))
                    continue;

                if (DEBUG)
                    System.out.println("    connected to (" + NameUtils.getSafeName(graph, stm.getObject()) + ", " + NameUtils.getSafeName(graph, connectionPoint2) + ")");

                connectedTo.add(new Terminal(stm.getObject(), connectionPoint2));
            }
        }

        return connectedTo;
    }

}
