/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.image.ui.modelBrowser;

import org.simantics.browsing.ui.graph.contributor.labeler.LabelerContributor;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class ImageLabeler extends LabelerContributor<ImageNode> {

    @Override
    public String getLabel(ReadGraph graph, ImageNode node) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        String name = graph.getPossibleRelatedValue(node.data, L0.HasName, Bindings.STRING);
        if(name == null)
            name = "No name"; //$NON-NLS-1$
        return name;    
    }

}
