package org.simantics.db.testing.common;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.simantics.db.testing.annotation.Always;
import org.simantics.db.testing.annotation.Fails;
import org.simantics.db.testing.annotation.Obsolete;
import org.simantics.utils.FileUtils;

public class RegressionFilter extends Filter {

	public static final String CLASSIFICATION_KEY = "regressionFilterClassification";
	public static final String CLASSIFICATION_KEY_1 = "1";
	public static final String CLASSIFICATION_KEY_2 = "2";
	public static final String CLASSIFICATION_KEY_3 = "3";
	public static final String CLASSIFICATION_KEY_4 = "4";
	
	private Failures tests;
	
    public RegressionFilter() {
        super();
        getTestCaseNames();
    }

    public String describe() {
        return "Filters out all failing tests.";
    }

    enum Classification {
    	REGRESSION1,REGRESSION2,REGRESSION3,REGRESSION4,ALWAYS
    }
    
    EnumSet<Classification> ALWAYS_CLASSES = EnumSet.of(Classification.REGRESSION1, Classification.REGRESSION2, Classification.ALWAYS);
    
    public Classification classify(Description d) {
    	
    	String testName = d.getDisplayName();
//    	System.err.println("classify " + testName);

    	Always a = d.getAnnotation(Always.class);
    	if(a != null) return Classification.ALWAYS;
    	
    	Obsolete o = d.getAnnotation(Obsolete.class);
    	if(o != null) return Classification.REGRESSION4;

    	Fails f = d.getAnnotation(Fails.class); 
    	if(f != null) return Classification.REGRESSION3;

    	Test t = d.getAnnotation(Test.class);
    	if(t == null) return Classification.ALWAYS;
    	
        if (tests == null) return Classification.REGRESSION1;

        for (int i = 0; i < tests.names.length; i++)
            if (testName.contains(tests.names[i]))
                return Classification.REGRESSION2;
        
        return Classification.REGRESSION1;
    	
    }
    
    private Classification getPass() {
    	String s = System.getProperty(CLASSIFICATION_KEY);
    	if(CLASSIFICATION_KEY_1.equals(s)) return Classification.REGRESSION1;
    	else if(CLASSIFICATION_KEY_2.equals(s)) return Classification.REGRESSION2;
    	else if(CLASSIFICATION_KEY_3.equals(s)) return Classification.REGRESSION3;
    	else if(CLASSIFICATION_KEY_4.equals(s)) return Classification.REGRESSION4;
    	else return null;
    }
    
    public boolean shouldRun(Description d) {
    	Classification cls = classify(d);
//    	System.err.println("-" + cls);
    	if(Classification.ALWAYS == cls) return true;
    	Classification pass = getPass();
    	if(pass == null && ALWAYS_CLASSES.contains(cls)) return true;
    	return pass == cls;
    }

    private void getTestCaseNames() {

    	if(tests != null) return;
    	
    	try {
    		
            String csv = FileUtils.getContents("failures.dat").replace("\r", "");
            tests = new Failures();
            Set<String> ss = new HashSet<String>();
            for(String s : csv.split("\n"))
            	if(!s.isEmpty()) ss.add(s);
            tests.names = ss.toArray(new String[ss.size()]);
            
//            System.err.println("tests.names = " + Arrays.toString(tests.names));
	    	
    	} catch (Exception e) {
    		
    		tests = new Failures();
    		tests.names = new String[] { };
    		
    	}
    	
    }
    
}
