/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.SelectionRequest;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.common.Testers;
import org.simantics.browsing.ui.content.ContributionViewpoint;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointContribution;
import org.simantics.browsing.ui.content.ViewpointContributionFactory;

public class DefaultViewpointContributionsProcessor extends AbstractNodeQueryProcessor<Collection<ViewpointContribution>> {

    public static final Collection<ViewpointContribution> EMPTY = Collections.emptyList();

    @Override
    public QueryKey<Collection<ViewpointContribution>> getIdentifier() {
        return BuiltinKeys.VIEWPOINT_CONTRIBUTIONS;
    }

    private String extractFilterString(Collection<SelectionRequest> requests) {
        if(requests == null) return null;
        for(SelectionRequest request : requests) {
            if(SelectionRequest.Request.FILTER.equals(request.getRequest())) {
                return request.getData();
            }
        }
        return null;
    }

    // TODO: evaluate still if this is ok
    private String adjustFilter(String filter) {
//        System.out.println("DefaultViewpointContributionsProcessor.adjustFilter=" + filter);
        if(filter == null) return null;
        String[] tokens = filter.split(" ");
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for(String token : tokens) {
//            System.out.println("DefaultViewpointContributionsProcessor.token=" + token);
            if(token.startsWith("$")) {
                if(first) first = false;
                else b.append(" ");
                b.append(token.substring(1));
            }
        }
        return b.toString();
    }

    @Override
    public Collection<ViewpointContribution> query(NodeQueryManager manager, NodeContext context_) {

        final Viewpoint viewpoint = manager.query(context_, BuiltinKeys.SELECTED_VIEWPOINT);
        if (viewpoint == null)
            return EMPTY;

        if(viewpoint instanceof ContributionViewpoint) {

            String filterString = null;
            Collection<SelectionRequest> selectionRequests = manager.query(context_, BuiltinKeys.SELECTION_REQUESTS);
            filterString = extractFilterString(selectionRequests);

            String adjustedFilter = adjustFilter(filterString);

            //System.out.println("DefaultViewpointContributionsProcessor: filter queries = " + filterString + " -> " + adjustedFilter);

            NodeContext context = NodeContextUtil.withConstant(context_, BuiltinKeys.FILTER, adjustedFilter);

            ArrayList<ViewpointContribution> result = new ArrayList<ViewpointContribution>();
            ContributionViewpoint contributionViewpoint = (ContributionViewpoint)viewpoint;
            for(ViewpointContributionFactory factory : contributionViewpoint.getContributions()) {
//            	System.out.println("viewpoint contribution " + factory);
//            	Class<?> clazz = factory.getInputClass();
//            	Tester test = factory.getNodeContextTester();
//            	if(clazz.isInstance(context.getConstant(BuiltinKeys.INPUT))) {
//                	if(test == null || test.test(manager, context)) {
                result.add(manager.query(context, new BuiltinKeys.ViewpointContributionKey(factory)));
//                	}
//            	}
            }
            return result;

        } else {

            ViewpointContribution contribution = new ViewpointContribution() {

                @Override
                public Collection<NodeContext> getContribution() {
                    ArrayList<NodeContext> result = new ArrayList<NodeContext>();
                    for(NodeContext context : viewpoint.getChildren()) result.add(context);
                    return result;
                }

                @Override
                public Tester getNodeContextTester() {
                    return Testers.PASS;
                }

                @Override
                public Class<?> getInputClass() {
                    return Object.class;
                }

            };

            return Collections.singletonList(contribution);

        }


//        Collection<ViewpointContribution> contributions = manager.query(context, BuiltinKeys.VIEWPOINT_CONTRIBUTIONS);
//        if (contributions == null)
//            return PrunedChildrenResult.EMPTY;
//
//        HashSet<INodeContext> children = new HashSet<INodeContext>();
//
//        for(ViewpointContribution contribution : contributions) {
//            children.addAll(contribution.getContribution());
//        }
//
////        Viewpoint viewpoint = manager.query(context, BuiltinKeys.SELECTED_VIEWPOINT);
////        if (viewpoint == null)
////            return PrunedChildrenResult.EMPTY;
////
////        INodeContext[] children = viewpoint.getChildren();
//
//        Collection<SelectionRequest> selectionRequests = manager.query(context, BuiltinKeys.SELECTION_REQUESTS);
//        if (selectionRequests == null)
//            return new PrunedChildrenResult(children.size(), children.toArray(INodeContext.NONE));
//
//        SelectionRequest[] reqs = selectionRequests.toArray(new SelectionRequest[selectionRequests.size()]);
//
//        ArrayList<INodeContext> pruned = new ArrayList<INodeContext>();
//        for (INodeContext ctx : children) {
//            boolean add = true;
//
//            if (selectionRequests != null) {
//                for(SelectionRequest req : reqs) {
//                    if (req.getRequest() == SelectionRequest.Request.HIDE) {
//                        if (req.isIncluded(manager, ctx)) {
//                            add = false;
//                            break;
//                        }
//                    }
//                }
//            }
//
//            if (add)
//                pruned.add(ctx);
//        }
//        return new PrunedChildrenResult(children.size(), pruned.toArray(INodeContext.NONE));

    }

    @Override
    public String toString() {
        return "ViewpointContributionsProcessor";
    }

}