/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.imagers;

import java.net.URL;

public class SingleImageURLs implements ImageURLs {

	private final String columnKey;
	private final URL url;
	
	public SingleImageURLs(String columnKey, URL url) {
		if(url == null) throw new IllegalArgumentException("Null url.");
		this.url = url;
		if(columnKey == null) throw new IllegalArgumentException("Null columnKey.");
		this.columnKey = columnKey;
	}

	@Override
	public URL getURL(String columnKey) {
		if(this.columnKey.equals(columnKey)) return url;
		else return null;
	}
	
}
