/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.extension;

import org.simantics.browsing.ui.common.extension.internal.CheckedStateContributorReferenceBinding;
import org.simantics.browsing.ui.common.extension.internal.ContributorReferenceBinding;
import org.simantics.browsing.ui.content.CheckedStateFactory;

/**
 * @author Tuukka Lehtonen
 */
public class CheckedStateContributorBindingExtensionManager extends ContributorBindingExtensionManager<CheckedStateFactory> {

    private static CheckedStateContributorBindingExtensionManager INSTANCE;
    
    public static synchronized CheckedStateContributorBindingExtensionManager getInstance() {
        if (INSTANCE == null)
            INSTANCE = new CheckedStateContributorBindingExtensionManager();
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    @Override
    String getExtensionPointName() {
    	return "checkedStateBinding";
    }
    
    @Override
    ContributorReferenceBinding<CheckedStateFactory> createReferenceBinding(double preference, String browseContext, String factoryId) {
    	return new CheckedStateContributorReferenceBinding(preference, browseContext, factoryId);
    }

}
