/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example.old;

import java.io.File;
import java.io.IOException;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.file.FileList;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.SerializerConstructionException;

/**
 * File List Example
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class FileListExample {

	public static void main(String[] args) throws IOException, SerializerConstructionException, SerializationException, BindingConstructionException {
		
		// Create File
		File file = File.createTempFile("Example", "tmp");
		Binding binding = Bindings.getBinding( String.class );
		FileList<String> list = new FileList<String>( file, binding );
		list.add("Hello");
		list.close();
		
		// Open file
		list = new FileList<String>( file, binding );
		for (String line : list)
			System.out.println(line);
		list.close();
		
		file.delete();		
	}
	
}

