/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.swt.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.client.CommandManager;
import org.simantics.document.server.client.CommandMapping;
import org.simantics.document.server.client.CommandMappingImpl;
import org.simantics.document.server.client.Document;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.client.WidgetManager;
import org.simantics.document.server.client.WidgetMapping;
import org.simantics.document.server.client.WidgetMappingImpl;
import org.simantics.document.server.io.ICommand;
import org.simantics.document.swt.core.base.ScrolledCompositeContent;
import org.simantics.document.swt.core.widget.BrowserWidget;
import org.simantics.document.swt.core.widget.ButtonWidget;
import org.simantics.document.swt.core.widget.ComboWidget;
import org.simantics.document.swt.core.widget.CommandEventWidget;
import org.simantics.document.swt.core.widget.Explorer;
import org.simantics.document.swt.core.widget.FillComposite;
import org.simantics.document.swt.core.widget.GridCell;
import org.simantics.document.swt.core.widget.GridComposite;
import org.simantics.document.swt.core.widget.LabelWidget;
import org.simantics.document.swt.core.widget.SCLTextEditor;
import org.simantics.document.swt.core.widget.ScrolledCompositeWidget;
import org.simantics.document.swt.core.widget.TrackedTextWidget;
import org.simantics.utils.datastructures.Pair;

public class SWTViews {
    private static WidgetMappingImpl mapping = null;
    private static CommandMappingImpl commandMapping = null;
    public static Map<String, Object> encoded = new HashMap<String, Object>();

    public static WidgetMapping getMapping() {
        if (mapping == null) {
            mapping = new WidgetMappingImpl();
            mapping.register("Root", (WidgetManager)new FillComposite());
            mapping.register("GridComposite", (WidgetManager)new GridComposite());
            mapping.register("ScrolledComposite", (WidgetManager)new ScrolledCompositeWidget());
            mapping.register("GridCell", (WidgetManager)new GridCell());
            mapping.register("Label", (WidgetManager)new LabelWidget());
            mapping.register("Button", (WidgetManager)new ButtonWidget());
            mapping.register("TrackedText", (WidgetManager)new TrackedTextWidget());
            mapping.register("Combo", (WidgetManager)new ComboWidget());
            mapping.register("Explorer", (WidgetManager)new Explorer());
            mapping.register("CommandEvent", (WidgetManager)new CommandEventWidget());
            mapping.register("Browser", (WidgetManager)new BrowserWidget());
            mapping.register("SCLTextEditor", (WidgetManager)new SCLTextEditor());
        }
        return mapping;
    }

    public static CommandMapping getCommandMapping() {
        if (commandMapping == null) {
            commandMapping = new CommandMappingImpl();
            commandMapping.register("Button", (CommandManager)new ButtonWidget.ButtonCommandManager());
            commandMapping.register("Explorer", (CommandManager)new Explorer.ExplorerCommandManager());
        }
        return commandMapping;
    }

    public static List<Pair<WidgetData, ICommand>> getTriggeredCommands(Document document, Collection<ICommand> commands, String trigger) {
        assert (commands != null);
        ArrayList<Pair<WidgetData, ICommand>> data = new ArrayList<Pair<WidgetData, ICommand>>();
        for (ICommand c : commands) {
            WidgetData wd;
            if (c.getCommand() == null || c.getTargetId() == null || c.getTrigger() == null || !trigger.equals(c.getTrigger()) || (wd = (WidgetData)document.getWidgetData().get(c.getTargetId())) == null) continue;
            data.add((Pair<WidgetData, ICommand>)new Pair((Object)wd, (Object)c));
        }
        return data;
    }

    public static void notifyScrolledComposite(Control c) {
        if (c instanceof ScrolledCompositeContent) {
            ScrolledCompositeContent content = (ScrolledCompositeContent)c;
            content.refreshSize();
            return;
        }
        Composite parent = c.getParent();
        if (parent == null) {
            return;
        }
        SWTViews.notifyScrolledComposite((Control)parent);
    }

    public static String encode(JSONObject object, String property, Object data) {
        String key = String.valueOf(object.getId()) + "#" + property;
        encoded.put(key, data);
        return key;
    }

    public static Object decode(String key) {
        return encoded.get(key);
    }
}

