/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.util;

import java.util.List;
import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.event.ontology.EventResource;
import org.simantics.layer0.Layer0;

public class EventUtils {
    public static final int MAX_EVENTS = 1000;
    public static final int SLICE_SIZE = 64;
    public static final int KEEPS_SLICES = 17;
    public static final String MAX_SLICE_NAME = "63";

    public static Resource createLog(WriteGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        Resource log = graph.newResource();
        graph.claim(log, L0.InstanceOf, null, EVENT.EventLog);
        graph.claimLiteral(log, L0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        graph.claimLiteral(log, EVENT.HasModificationCounter, (Object)0, (Binding)Bindings.INTEGER);
        return log;
    }

    public static void bumpModificationCounter(WriteGraph graph, List<Resource> forLogOfEvents) throws DatabaseException {
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        for (Resource event : forLogOfEvents) {
            Resource log = (Resource)graph.syncRequest((Read)new PossibleTypedParent(event, EVENT.EventLog));
            if (log == null) continue;
            EventUtils.bumpModificationCounter(graph, log);
            return;
        }
    }

    public static int bumpModificationCounter(WriteGraph graph, Resource eventLog) throws DatabaseException {
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        Resource counter = graph.getPossibleObject(eventLog, EVENT.HasModificationCounter);
        if (counter != null) {
            Integer c = (Integer)graph.getValue(counter, (Binding)Bindings.INTEGER);
            c = c == null ? 1 : c + 1;
            graph.claimValue(counter, (Object)c, (Binding)Bindings.INTEGER);
            return c;
        }
        return 0;
    }
}

