/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.DatabaseJob;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.modeling.ui.diagramEditor.DiagramViewer;
import org.simantics.modeling.ui.diagramEditor.Messages;
import org.simantics.utils.DataContainer;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class DiagramViewerLoadJob
extends DatabaseJob {
    private static final boolean PROFILE = false;
    private DiagramViewer viewer;

    public DiagramViewerLoadJob(DiagramViewer viewer) {
        super(Messages.DiagramViewerLoadJob_LoadDiagram);
        this.setUser(true);
        this.viewer = viewer;
    }

    protected IStatus run(IProgressMonitor monitor) {
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DiagramViewerLoadJob_MonitorLoadingDiagram, (int)200);
        try {
            Object task = DiagramViewerLoadJob.BEGIN("DV.loadDiagram");
            final IDiagram diagram = this.viewer.loadDiagram((IProgressMonitor)mon.newChild(100), this.viewer.diagramResource);
            if (diagram == null) {
                return Status.CANCEL_STATUS;
            }
            DiagramViewerLoadJob.END(task);
            task = DiagramViewerLoadJob.BEGIN("DV.performActivation");
            this.viewer.performActivation((IProgressMonitor)mon.newChild(50));
            DiagramViewerLoadJob.END(task);
            ThreadUtils.syncExec((IThreadWorkQueue)this.viewer.canvasContext.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    DiagramViewerLoadJob.this.setThread(((DiagramViewerLoadJob)DiagramViewerLoadJob.this).viewer.canvasContext.getThreadAccess().getThread());
                    mon.setTaskName(Messages.DiagramViewerLoadJob_MonitorFinalizeDiagramLoading);
                    try {
                        Object task = DiagramViewerLoadJob.BEGIN("DV.beforeSetDiagram");
                        DiagramViewerLoadJob.this.viewer.beforeSetDiagram(diagram);
                        mon.worked(10);
                        DiagramViewerLoadJob.END(task);
                        task = DiagramViewerLoadJob.BEGIN("DV.setDiagramHint");
                        mon.subTask(Messages.DiagramViewerLoadJob_SetDiagram);
                        DataContainer<IDiagram> diagramContainer = ((DiagramViewerLoadJob)DiagramViewerLoadJob.this).viewer.sourceDiagramContainer;
                        if (diagramContainer != null) {
                            diagramContainer.set((Object)diagram);
                        }
                        ((DiagramViewerLoadJob)DiagramViewerLoadJob.this).viewer.sourceDiagram = diagram;
                        ((DiagramViewerLoadJob)DiagramViewerLoadJob.this).viewer.canvasContext.getDefaultHintContext().setHint(DiagramHints.KEY_DIAGRAM, (Object)diagram);
                        mon.worked(10);
                        DiagramViewerLoadJob.END(task);
                        ((DiagramViewerLoadJob)DiagramViewerLoadJob.this).viewer.selectionProvider.fireSelection(Collections.emptyList());
                        task = DiagramViewerLoadJob.BEGIN("DV.scheduleZoomToFit");
                        DiagramViewerLoadJob.this.viewer.scheduleZoomToFit(diagram);
                        mon.worked(10);
                        DiagramViewerLoadJob.END(task);
                        task = DiagramViewerLoadJob.BEGIN("DV.onCreated");
                        mon.subTask("");
                        DiagramViewerLoadJob.this.viewer.onCreated();
                        mon.worked(10);
                        DiagramViewerLoadJob.END(task);
                        task = DiagramViewerLoadJob.BEGIN("DV.applyEditorState");
                        mon.subTask(Messages.DiagramViewerLoadJob_ApplyEditorState);
                        DiagramViewerLoadJob.this.viewer.applyEditorState(((DiagramViewerLoadJob)DiagramViewerLoadJob.this).viewer.editorState, (ICanvasContext)((DiagramViewerLoadJob)DiagramViewerLoadJob.this).viewer.canvasContext);
                        mon.worked(10);
                        DiagramViewerLoadJob.END(task);
                        task = DiagramViewerLoadJob.BEGIN("DV.activateUiContexts");
                        ((DiagramViewerLoadJob)DiagramViewerLoadJob.this).viewer.contextUtil.inContextThread(new Runnable(){

                            @Override
                            public void run() {
                                if (!((DiagramViewerLoadJob)(this).DiagramViewerLoadJob.this).viewer.disposed) {
                                    DiagramViewerLoadJob.this.viewer.activateUiContexts(((DiagramViewerLoadJob)(this).DiagramViewerLoadJob.this).viewer.contextUtil);
                                }
                                DiagramViewerLoadJob.this.viewer = null;
                            }
                        });
                        DiagramViewerLoadJob.END(task);
                    }
                    catch (Throwable throwable) {
                        DiagramViewerLoadJob.this.viewer = null;
                    }
                }
            });
            return Status.OK_STATUS;
        }
        catch (CancelTransactionException e) {
            monitor.done();
            this.viewer = null;
            return new Status(8, "org.simantics.modeling.ui", Messages.DiagramViewerLoadJob_ActivatorDiagramLoadingCancelled, (Throwable)e);
        }
        catch (Throwable t) {
            monitor.done();
            this.viewer = null;
            return new Status(4, "org.simantics.modeling.ui", Messages.DiagramViewerLoadJob_ActivatorDiagramLoadingFailed, t);
        }
    }

    protected static Object BEGIN(String name) {
        return null;
    }

    protected static void END(Object task) {
    }
}

