/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.QueryProcessor;

class QueryCollectorImpl
implements QueryProcessor.QueryCollector {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_STATUS = false;
    private final QueryProcessor queryProcessor;
    private final QueryProcessor.QueryCollectorSupport support;
    boolean doneAll = false;
    int moreAll = 0;
    boolean propagate = true;
    private static final int COLLECT_N = 1000;
    private long spent = 0L;

    QueryCollectorImpl(QueryProcessor queryProcessor, QueryProcessor.QueryCollectorSupport support) {
        this.queryProcessor = queryProcessor;
        this.support = support;
    }

    @Override
    public void collect(int youngTarget, int allowedTimeInMs) {
        long start = System.nanoTime();
        int size = this.support.calculateCurrentSize();
        int bound = this.queryProcessor.boundQueries;
        int young = size - bound;
        int youngPct = size > 0 ? 100 * young / size : 0;
        if (this.support.start(youngTarget == 0)) {
            this.moreAll = 0;
            CacheEntryBase prospect = this.support.iterate(0);
            while (prospect != null) {
                if (prospect.isDiscarded()) {
                    this.support.remove();
                    this.propagate = true;
                } else {
                    CacheEntry parent = prospect.getFirstParent(this.queryProcessor);
                    if (parent == null) {
                        this.tryCollect(prospect);
                    } else {
                        this.support.setLevel(prospect, parent.getLevel() + 1);
                    }
                }
                prospect = this.support.iterate(0);
            }
            if (!this.propagate && youngPct < youngTarget) {
                return;
            }
        }
        long test = (long)allowedTimeInMs * 1000000L;
        this.start();
        block1: while (true) {
            boolean timeCondition;
            size = this.support.getCurrentSize();
            bound = this.queryProcessor.boundQueries;
            long elapsed = System.nanoTime() - start;
            boolean bl = timeCondition = elapsed > test;
            if (this.doneAll || timeCondition) {
                this.spent += elapsed;
                return;
            }
            if (this.doneAll) continue;
            int i = 0;
            while (true) {
                int status;
                boolean collected;
                if (i >= 1000) continue block1;
                CacheEntryBase entry = this.support.iterate(Integer.MAX_VALUE);
                if (entry == null) {
                    if (this.moreAll < 1000) {
                        this.doneAll = true;
                        this.propagate = false;
                    }
                    this.moreAll = 0;
                    continue block1;
                }
                CacheEntry parent = entry.getFirstParent(this.queryProcessor);
                if (parent == null) {
                    collected = this.tryCollect(entry);
                    if (!collected) {
                        entry.setLevel((short)0);
                    }
                } else {
                    parent = entry.pruneFirstParents();
                    if (parent == null) {
                        collected = this.tryCollect(entry);
                        if (!collected) {
                            entry.setLevel((short)0);
                        }
                    } else {
                        this.support.setLevel(entry, parent.getLevel() + 1);
                    }
                }
                if (((status = entry.getGCStatus()) & 1) == 0) {
                    if (parent != null && !parent.isDiscarded() && (parent.getGCStatus() & 1) != 0) {
                        ++this.queryProcessor.boundQueries;
                        entry.setGCStatusFlag(1, true);
                    }
                    if (this.queryProcessor.listening.hasListenerAfterDisposing(entry) && (status & 1) == 0) {
                        ++this.queryProcessor.boundQueries;
                        entry.setGCStatusFlag(1, true);
                    }
                }
                ++i;
            }
            break;
        }
    }

    private boolean tryCollect(CacheEntry entry) {
        if (!this.queryProcessor.listening.hasListenerAfterDisposing(entry) && entry.shouldBeCollected()) {
            this.queryProcessor.removeQuery(entry);
            this.support.remove();
            this.propagate = true;
            ++this.moreAll;
            this.doneAll = false;
            return true;
        }
        return false;
    }

    private void start() {
        this.moreAll = 1;
        this.doneAll = false;
    }
}

