/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.db.management.ISessionContext;
import org.simantics.selectionview.IPropertyTab;
import org.simantics.selectionview.PropertyTabContributor;

public class ComparableTabContributor
implements PropertyTabContributor,
Comparable<ComparableTabContributor> {
    private final PropertyTabContributor orig;
    private final double priority;
    private final Object input;
    private final String label;
    private final String id;
    private final Image image;

    public ComparableTabContributor(PropertyTabContributor orig, double priority, Object input, String label) {
        this(orig, priority, input, label, null);
    }

    public ComparableTabContributor(PropertyTabContributor orig, double priority, Object input, String label, Image image) {
        this(orig, priority, input, label, label, image);
    }

    public ComparableTabContributor(PropertyTabContributor orig, double priority, Object input, String label, String id, Image image) {
        if (orig == null) {
            throw new NullPointerException("null property tab contributor");
        }
        if (input == null) {
            throw new NullPointerException("null input");
        }
        if (label == null) {
            throw new NullPointerException("null label");
        }
        this.orig = orig;
        this.priority = priority;
        this.input = input;
        this.label = label;
        this.id = id;
        this.image = image;
    }

    @Override
    public IPropertyTab create(Composite parent, IWorkbenchSite site, ISessionContext context, Object input) {
        return this.orig.create(parent, site, context, input);
    }

    public String getLabel() {
        return this.label;
    }

    public Image getImage() {
        return this.image;
    }

    public Object getInput() {
        return this.input;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(ComparableTabContributor o) {
        int comp = Double.compare(o.priority, this.priority);
        if (comp != 0) {
            return comp;
        }
        return this.id.compareTo(o.id);
    }

    public int hashCode() {
        return this.orig.hashCode() ^ Double.valueOf(this.priority).hashCode() ^ this.input.hashCode() ^ this.label.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ComparableTabContributor)) {
            return false;
        }
        ComparableTabContributor r = (ComparableTabContributor)object;
        return this.orig.equals(r.orig) && this.priority == r.priority && this.input.equals(r.input) && this.label.equals(r.label);
    }

    public String toString() {
        return this.orig + "[" + this.label + "] " + this.priority + " " + this.input;
    }
}

