/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants.generic;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.constants.generic.StackItem;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.PreparationStep;
import org.simantics.scl.compiler.internal.codegen.utils.SCLContextPreparationStep;

public class ThreadLocalStackItem
implements StackItem,
PreparationStep<LocalVariable> {
    private static final TypeDesc THREAD_LOCAL = TypeDesc.forClass(ThreadLocal.class);
    String variableName;
    TypeDesc type;

    public ThreadLocalStackItem(String variableName, TypeDesc type) {
        this.variableName = variableName;
        this.type = type;
    }

    @Override
    public void push(MethodBuilder mb, Val[] parameters) {
        mb.loadLocal(mb.getPreparation(this));
    }

    @Override
    public void prepare(MethodBuilder mb) {
        LocalVariable var = mb.getPreparation(this);
        if (var == null) {
            var = mb.createLocalVariable("context", this.type);
            LocalVariable sclContext = SCLContextPreparationStep.getCurrent(mb);
            mb.loadLocal(sclContext);
            mb.loadConstant(this.variableName);
            mb.invokeVirtual("gnu/trove/map/hash/THashMap", "get", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.OBJECT});
            mb.checkCast(this.type);
            mb.storeLocal(var);
            mb.addPreparation(this, var);
        }
    }

    public int hashCode() {
        return 234234 + this.type.hashCode() + 31 * this.variableName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadLocalStackItem other = (ThreadLocalStackItem)obj;
        return this.variableName.equals(other.variableName) && this.type.equals(other.type);
    }
}

