/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.ui.internal;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procore.ui.internal.Messages;

public class Util {
    private static String NL = System.getProperty("line.separator");

    static void showInfo(Shell shell, String message) {
        MessageDialog.openInformation((Shell)shell, (String)Messages.Util_Information, (String)message);
    }

    static void showWarning(Shell shell, String message) {
        MessageDialog.openWarning((Shell)shell, (String)Messages.Util_Warning, (String)message);
    }

    public static void showError(Shell shell, String message) {
        Util.showError(shell, message, null);
    }

    static void showError(Shell shell, String message, Throwable t) {
        Logger.defaultLogError((String)message, (Throwable)t);
        if (t != null) {
            message = String.valueOf(message) + "\n" + t.getMessage();
        }
        MessageDialog.openError((Shell)shell, (String)Messages.Util_Error, (String)message);
    }

    public static void logError(String message) {
        Util.logError(message, null);
    }

    public static void logError(String message, Throwable cause) {
        Logger.defaultLogError((String)message, (Throwable)cause);
    }

    public static void trace(Class<?> clazz) {
        Util.trace(clazz, null);
    }

    public static void trace(String message) {
        Util.trace(null, message);
    }

    public static void trace(Class<?> clazz, String message) {
        String s = "";
        if (clazz != null) {
            s = String.valueOf(s) + clazz.getSimpleName() + " called.\n";
        }
        if (message != null) {
            s = String.valueOf(s) + message;
        }
        Logger.defaultLogInfo((String)s);
    }

    public static int select(Shell shell, String title, String message, Choice[] choices, int def) {
        assert (choices.length > 0);
        if (def < 0 || def >= choices.length) {
            def = 0;
        }
        String[] labels = new String[choices.length];
        StringBuilder sb = new StringBuilder(message.length() + 256);
        sb.append(message);
        int i = 0;
        while (i < labels.length) {
            labels[i] = choices[i].button;
            sb.append(String.valueOf(NL) + NL + choices[i].text);
            ++i;
        }
        if (Display.getDefault().getThread() == Thread.currentThread()) {
            return Util.select(shell, title, sb.toString(), labels, def);
        }
        class SelectRunnable
        implements Runnable {
            int ret;
            int def;
            private final /* synthetic */ Shell val$shell;
            private final /* synthetic */ String val$title;
            private final /* synthetic */ StringBuilder val$sb;
            private final /* synthetic */ String[] val$labels;

            SelectRunnable(int def, Shell shell, String string, StringBuilder stringBuilder, String[] stringArray) {
                this.val$shell = shell;
                this.val$title = string;
                this.val$sb = stringBuilder;
                this.val$labels = stringArray;
                this.def = def;
            }

            @Override
            public void run() {
                this.ret = Util.select(this.val$shell, this.val$title, this.val$sb.toString(), this.val$labels, this.def);
            }
        }
        SelectRunnable sr = new SelectRunnable(def, shell, title, sb, labels);
        Display.getDefault().syncExec((Runnable)sr);
        return sr.ret;
    }

    private static int select(Shell shell, String title, String message, String[] labels, int def) {
        MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, labels, def);
        int answer = dialog.open();
        if (answer < 0 || answer >= labels.length) {
            answer = 0;
        }
        return answer;
    }

    public static boolean confirm(Shell shell, String title, String message) {
        String[] labels = new String[]{Messages.Util_Yes, Messages.Util_No};
        MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, labels, 1);
        int answer = dialog.open();
        return answer == 0;
    }

    public static boolean openDefaultNo(Shell shell, String title, String message, int style) {
        String[] labels = new String[]{Messages.Util_Yes, Messages.Util_No};
        MessageDialog dialog = new MessageDialog(shell, title, null, message, style, labels, 1);
        int answer = dialog.open();
        return answer == 0;
    }

    public static String getMessage(Throwable t) {
        StringBuilder s = new StringBuilder(t.getMessage());
        int i = 0;
        Throwable c = t.getCause();
        while (c != null && i < 10) {
            s.append(String.valueOf(NL) + "cause: " + c.getMessage());
            ++i;
            c = c.getCause();
        }
        return s.toString();
    }

    static class Choice {
        public String button;
        public String text;

        public Choice(String button, String text) {
            this.button = button;
            this.text = text;
        }
    }
}

