/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.internal.awt;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.utils.ui.internal.awt.AwtEnvironment;
import org.simantics.utils.ui.internal.awt.Platform;

class SwtInputBlocker
extends Dialog {
    private static SwtInputBlocker instance = null;
    private static int blockCount = 0;
    private Shell shell;

    private SwtInputBlocker(Shell parent) {
        super(parent, 0);
    }

    private Object open() {
        assert (Display.getCurrent() != null);
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 65536);
        this.shell.setSize(0, 0);
        this.shell.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (Platform.isGtk()) {
                    SwtInputBlocker.this.shell.moveBelow(null);
                }
                AwtEnvironment.getInstance(SwtInputBlocker.this.shell.getDisplay()).requestAwtDialogFocus();
            }
        });
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return null;
    }

    private void close() {
        assert (this.shell != null);
        this.shell.dispose();
    }

    static void unblock() {
        assert (blockCount >= 0);
        assert (Display.getCurrent() != null);
        if (blockCount == 0) {
            return;
        }
        if (blockCount == 1 && instance != null) {
            instance.close();
            instance = null;
        }
        --blockCount;
    }

    static void block() {
        assert (blockCount >= 0);
        Display display = Display.getCurrent();
        assert (display != null);
        if (++blockCount == 1) {
            assert (instance == null);
            Shell shell = AwtEnvironment.getInstance(display).getShell();
            if (shell != null) {
                instance = new SwtInputBlocker(shell);
                instance.open();
            }
        }
    }
}

