/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx.clipboard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.gfx.clipboard.streams.AddBitmapHeaderInputStream;
import org.simantics.utils.ui.gfx.clipboard.streams.RemoveBitmapHeaderOutputStream;
import org.simantics.utils.ui.gfx.clipboard.streams.UncompressedDIBInputStream;

public class ImageDataTransfer
extends ByteArrayTransfer {
    private static final ImageDataTransfer instance = new ImageDataTransfer();
    private static final String CF_DIB = "CF_DIB";

    private ImageDataTransfer() {
    }

    public static ImageDataTransfer getInstance() {
        return instance;
    }

    protected final int[] getTypeIds() {
        return new int[]{8};
    }

    protected final String[] getTypeNames() {
        return new String[]{CF_DIB};
    }

    protected Object nativeToJava(TransferData transferData) {
        ImageData[] data;
        block3: {
            Object o = super.nativeToJava(transferData);
            byte[] bytes = (byte[])o;
            try {
                AddBitmapHeaderInputStream iStream = new AddBitmapHeaderInputStream(new UncompressedDIBInputStream(new ByteArrayInputStream(bytes)));
                data = new ImageLoader().load((InputStream)iStream);
                if (data.length > 0) break block3;
                return null;
            }
            catch (IOException e) {
                ErrorLogger.defaultLogError("Cannot get image from clipboard", e);
                return null;
            }
        }
        return data[0];
    }

    protected void javaToNative(Object object, TransferData transferData) {
        ImageData imgData = (ImageData)object;
        ImageLoader loader = new ImageLoader();
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        loader.data = new ImageData[]{imgData};
        loader.save((OutputStream)new RemoveBitmapHeaderOutputStream(oStream), 0);
        byte[] bytes = oStream.toByteArray();
        super.javaToNative((Object)bytes, transferData);
    }
}

