/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.graph.impl.CommonKeys;
import org.simantics.browsing.ui.graph.impl.LazyGraphQueryProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.Container;

public class RelatedObjectsQueryProcessor
extends LazyGraphQueryProcessor<Collection<Resource>> {
    @Override
    public String toString() {
        return "RelatedObjectsProcessor";
    }

    public Object getIdentifier() {
        return CommonKeys.RelatedObjectsKey.class;
    }

    @Override
    protected Collection<Resource> initial() {
        return Collections.emptySet();
    }

    @Override
    protected Collection<Resource> compute(ReadGraph graph, NodeContext context, NodeContext.PrimitiveQueryKey<Container<Collection<Resource>>> key) throws DatabaseException {
        Object input = context.getConstant(BuiltinKeys.INPUT);
        Resource subject = RelatedObjectsQueryProcessor.adaptToSingle(input, Resource.class);
        CommonKeys.RelatedObjectsKey k = (CommonKeys.RelatedObjectsKey)key;
        Resource relation = (Resource)k.getParameter(0);
        if (relation == null) {
            return Collections.emptyList();
        }
        return graph.getObjects(subject, relation);
    }

    public static <T> T adaptToSingle(Object o, Class<T> clazz) {
        if (clazz.isInstance(o)) {
            return (T)o;
        }
        if (o instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)o;
            return (T)a.getAdapter(clazz);
        }
        if (o instanceof Container) {
            Object obj = ((Container)o).get();
            if (obj == o) {
                return null;
            }
            return RelatedObjectsQueryProcessor.adaptToSingle(obj, clazz);
        }
        return null;
    }
}

