/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.UndoContext;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ErrorLogger;

public class EnumerationVariableModifier2
implements Labeler.EnumerationModifier {
    protected final Session session;
    protected final UndoContext undoContext;
    protected final Variable variable;
    protected final Set<String> allowedValues;
    protected final String defaultValue;
    protected Throwable modifierFailed;

    public EnumerationVariableModifier2(RequestProcessor processor, UndoContext undoContext, Variable variable) {
        this.session = processor.getSession();
        this.undoContext = undoContext;
        this.variable = variable;
        this.allowedValues = this.computeAllowedValues(processor, variable);
        this.defaultValue = this.computeDefaultValue(processor, variable);
    }

    protected String computeDefaultValue(RequestProcessor processor, final Variable variable) {
        try {
            return (String)processor.syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    return (String)variable.getPossiblePropertyValue(graph, "HasLabel");
                }
            });
        }
        catch (DatabaseException databaseException) {
            return "";
        }
    }

    protected Set<String> computeAllowedValues(RequestProcessor processor, final Variable variable) {
        try {
            return (Set)processor.syncRequest((Read)new Read<Set<String>>(){

                public Set<String> perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    HashSet<String> result = new HashSet<String>();
                    Resource literal = variable.getPossibleRepresents(graph);
                    Resource type = graph.getSingleObject(literal, L0.PartOf);
                    for (Resource lit : (Collection)graph.syncRequest((Read)new ObjectsWithType(type, L0.ConsistsOf, type))) {
                        String label = (String)graph.getPossibleRelatedValue(lit, L0.HasLabel);
                        if (label == null) {
                            label = (String)graph.getRelatedValue(lit, L0.HasName);
                        }
                        result.add(label);
                    }
                    return result;
                }
            });
        }
        catch (DatabaseException databaseException) {
            return Collections.emptySet();
        }
    }

    protected void doModify(String label) {
        this.session.asyncRequest((org.simantics.db.request.Write)new Write(this.variable, label), parameter -> {
            if (parameter != null) {
                ErrorLogger.defaultLogError((Throwable)parameter);
            }
        });
    }

    public String getValue() {
        return this.defaultValue;
    }

    public String isValid(String label) {
        if (this.modifierFailed != null) {
            return "Could not resolve validator for this value, modification denied. Reason: " + this.modifierFailed.getMessage();
        }
        return null;
    }

    public final void modify(String label) {
        if (this.modifierFailed != null) {
            throw new Error("modifier failed: " + this.modifierFailed.getMessage());
        }
        this.doModify(label);
    }

    public List<String> getValues() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.allowedValues);
        return result;
    }

    public class Write
    extends WriteRequest {
        private final Variable variable;
        private final String label;

        public Write(Variable variable, String label) {
            super(null);
            this.variable = variable;
            this.label = label;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            this.variable.setValue(graph, (Object)this.label, (Binding)Bindings.STRING);
        }
    }
}

