/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.refactoring;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.graph.refactoring.GraphRefactoringUtils;
import org.simantics.graph.refactoring.TransferableGraphHasher;
import org.simantics.graph.representation.PrettyPrintTG;
import org.simantics.graph.representation.TransferableGraph1;

public class FixExportedOntology {
    static TransferableGraph1 convertExportedSharedOntologyIntoBundleOntology(Path input, Path output) throws Exception {
        System.out.format("Converting exported shared ontology%n\t" + input.toString() + "%nto bundle-compatible ontology%n\t" + output.toString(), new Object[0]);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(input, new OpenOption[0]), 131072);){
            Binding tgBinding = TransferableGraph1.BINDING;
            DataContainer container = DataContainers.readFile((DataInput)new DataInputStream(is), (Binding)tgBinding);
            TransferableGraph1 graph = (TransferableGraph1)container.content.getValue(tgBinding);
            GraphRefactoringUtils.fixOntologyExport(graph);
            container = TransferableGraphHasher.addHashToTG(container, graph);
            DataContainers.writeFile((File)output.toFile(), (DataContainer)container);
            return graph;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void createTg(Path input) throws Exception {
        Path output = input.getParent().resolve("graph.tg");
        FixExportedOntology.createTg(input, output);
    }

    private static void createTg(Path input, Path output) throws Exception {
        FixExportedOntology.convertExportedSharedOntologyIntoBundleOntology(input, output);
    }

    public static void createTGAndPGraph(Path input) throws Exception {
        String newName = input.getFileName().toString();
        if (newName.contains(".")) {
            newName = newName.split("\\.")[0];
        }
        Path parent = input.getParent();
        Path output1 = parent.resolve(String.valueOf(newName) + ".tg");
        TransferableGraph1 tg = FixExportedOntology.convertExportedSharedOntologyIntoBundleOntology(input, output1);
        String listing = PrettyPrintTG.print(tg, false);
        Path output2 = parent.resolve(String.valueOf(newName) + ".pgraph");
        Files.write(output2, listing.getBytes(), StandardOpenOption.CREATE);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Required arguments: <input .sharedLibrary file> [<output .tg file>]");
        } else if (args.length == 1) {
            Path input = Paths.get(args[0], new String[0]);
            FixExportedOntology.createTGAndPGraph(input);
        } else {
            FixExportedOntology.convertExportedSharedOntologyIntoBundleOntology(Paths.get(args[0], new String[0]), Paths.get(args[1], new String[0]));
        }
    }
}

