/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.client;

import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;

public class ContinuousSynchronizationJob
extends DatabaseJob {
    public static final String FAMILY = "ContinuousSynchronizationJob";
    private final ConcurrentMap<IExperiment, Job> currentSyncJobs;
    IExperiment experiment;

    public ContinuousSynchronizationJob(IExperiment experiment, ConcurrentMap<IExperiment, Job> currentSyncJobs) {
        super("Synchronization");
        this.experiment = experiment;
        this.currentSyncJobs = currentSyncJobs;
        this.setPriority(20);
        this.setSystem(false);
    }

    public boolean belongsTo(Object family) {
        if (FAMILY == family) {
            return true;
        }
        return super.belongsTo(family);
    }

    public boolean shouldRun() {
        return this.currentSyncJobs.remove(this.experiment, (Object)this);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("", -1);
            if (this.experiment.getState() != ExperimentState.DISPOSED) {
                this.experiment.refresh(Simantics.getSession());
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Throwable t) {
            Status status = new Status(4, "org.simantics.structural.synchronization.client", "Failed to refresh experiment " + this.experiment + " with ID " + this.experiment.getIdentifier(), t);
            return status;
        }
        finally {
            monitor.done();
        }
    }
}

