/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.UnionAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.forms.DataboardForm;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.FormatClass;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.pdf.ExportPdfWriter;
import org.simantics.export.core.pdf.FontMapping;
import org.simantics.export.core.pdf.ImportPdfReader;
import org.simantics.export.core.util.ExporterUtils;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;

public class ExportPdfFormat
implements FormatClass {
    public static final Pattern PATTERN_PDF = Pattern.compile(".*\\.pdf$", 2);
    public static String S_PDF = "Portable Document Format (PDF)";
    public static ChildReference P_PDF_TITLE = ChildReference.parsePath((String)(String.valueOf(S_PDF) + "/Title"));
    public static ChildReference P_PDF_AUTHOR = ChildReference.parsePath((String)(String.valueOf(S_PDF) + "/Author"));
    public static ChildReference P_PDF_SUBJECT = ChildReference.parsePath((String)(String.valueOf(S_PDF) + "/Subject"));
    public static ChildReference P_PDF_KEYWORDS = ChildReference.parsePath((String)(String.valueOf(S_PDF) + "/Keywords"));
    public static ChildReference P_PDF_COMPRESSION = ChildReference.parsePath((String)(String.valueOf(S_PDF) + "/Compression"));
    public static String S_SIGN = "Digital Signature";
    public static LabelReference P_SIGN = new LabelReference(S_SIGN);
    public static ChildReference P_SIGN_KEYSTORE = ChildReference.concatenate((ChildReference)P_SIGN, (ChildReference)new LabelReference("Keystore"));
    public static ChildReference P_SIGN_KEYSTOREPASSWORD = ChildReference.concatenate((ChildReference)P_SIGN, (ChildReference)new LabelReference("Keystore Password"));
    public static ChildReference P_SIGN_PRIVATEKEYPASSWORD = ChildReference.concatenate((ChildReference)P_SIGN, (ChildReference)new LabelReference("Private Key Password"));
    public static ChildReference P_SIGN_LOCATION = ChildReference.concatenate((ChildReference)P_SIGN, (ChildReference)new LabelReference("Sign Location"));
    public static ChildReference P_SIGN_REASON = ChildReference.concatenate((ChildReference)P_SIGN, (ChildReference)new LabelReference("Sign Reason"));
    public static String S_PAGE = "Page Settings";
    public static ChildReference P_PAGE = new LabelReference(S_PAGE);
    public static ChildReference P_PAGE_PAPERSIZE = ChildReference.concatenate((ChildReference)P_PAGE, (ChildReference)new LabelReference("Size"));
    public static ChildReference P_PAGE_ORIENTATION = ChildReference.concatenate((ChildReference)P_PAGE, (ChildReference)new LabelReference("Orientation"));
    public static ChildReference P_PAGE_MARGIN_LEFT = ChildReference.concatenate((ChildReference)P_PAGE, (ChildReference)new LabelReference("Margin Left"));
    public static ChildReference P_PAGE_MARGIN_RIGHT = ChildReference.concatenate((ChildReference)P_PAGE, (ChildReference)new LabelReference("Margin Right"));
    public static ChildReference P_PAGE_MARGIN_TOP = ChildReference.concatenate((ChildReference)P_PAGE, (ChildReference)new LabelReference("Margin Top"));
    public static ChildReference P_PAGE_MARGIN_BOTTOM = ChildReference.concatenate((ChildReference)P_PAGE, (ChildReference)new LabelReference("Margin Bottom"));
    public static String PAGE_PLUGIN_ID = "org.simantics.modeling.ui";
    public static String P_DEFAULT_PAGE_SIZE = "page.default.size";
    private static final AtomicBoolean fontFactoryInitialized = new AtomicBoolean();
    public static final RecordType pdfOptions = new RecordType();

    static {
        DoubleType mm = new DoubleType();
        mm.setUnit("mm");
        RecordType pdfRecord = new RecordType();
        pdfRecord.addComponent("Title", (Datatype)Datatypes.STRING);
        pdfRecord.addComponent("Author", (Datatype)Datatypes.STRING);
        pdfRecord.addComponent("Subject", (Datatype)Datatypes.STRING);
        pdfRecord.addComponent("Keywords", DataboardForm.TEXTBOX);
        pdfRecord.addComponent("Compression", (Datatype)UnionType.newEnum((String[])new String[]{"0 (No compression)", "1", "2", "3", "4", "5", "6", "7", "8", "9 (Best)"}));
        RecordType pdfSign = new RecordType();
        StringType certificate = DataboardForm.fileOpenDialog((String[])new String[]{"PKCS#12 keystore (.p12)", "*.p12", "PFX (.pfx)", "*.pfx"});
        pdfSign.addComponent("Keystore", (Datatype)certificate);
        pdfSign.addComponent("Keystore Password", DataboardForm.PASSWORD);
        pdfSign.addComponent("Private Key Password", DataboardForm.PASSWORD);
        pdfSign.addComponent("Sign Location", (Datatype)Datatypes.STRING);
        pdfSign.addComponent("Sign Reason", (Datatype)Datatypes.STRING);
        PageDesc[] descs = PageDesc.PDF_ITEMS;
        String[] pageSizesStr = new String[descs.length];
        int i = 0;
        while (i < descs.length) {
            pageSizesStr[i] = descs[i].getText();
            ++i;
        }
        UnionType pageSizes = UnionType.newEnum((String[])new String[]{"A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "A10"});
        UnionType orientation = UnionType.newEnum((String[])new String[]{"Portrait", "Landscape"});
        RecordType pagePrefs = new RecordType();
        pagePrefs.addComponent("Size", (Datatype)pageSizes);
        pagePrefs.addComponent("Orientation", (Datatype)orientation);
        pagePrefs.addComponent("Margin Left", (Datatype)mm);
        pagePrefs.addComponent("Margin Right", (Datatype)mm);
        pagePrefs.addComponent("Margin Top", (Datatype)mm);
        pagePrefs.addComponent("Margin Bottom", (Datatype)mm);
        pdfOptions.addComponent(S_PDF, (Datatype)pdfRecord);
        pdfOptions.addComponent(S_SIGN, (Datatype)pdfSign);
        pdfOptions.addComponent(S_PAGE, (Datatype)pagePrefs);
    }

    @Override
    public RecordType options(ExportContext context) throws ExportException {
        return pdfOptions;
    }

    @Override
    public Object createFile(ExportContext ctx, File outputFile, Variant options) throws ExportException {
        try {
            Double top;
            Double bottom;
            Double right;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            if (fontFactoryInitialized.compareAndSet(false, true)) {
                FontFactory.registerDirectories();
            }
            ExportPdfWriter writer = new ExportPdfWriter();
            Rectangle pageSize = null;
            writer.document = new Document(pageSize);
            writer.outputFile = outputFile;
            writer.fos = new FileOutputStream(writer.outputFile);
            writer.pdfCopy = new PdfCopy(writer.document, (OutputStream)writer.fos);
            writer.pdfCopy.setPdfVersion(PdfWriter.PDF_VERSION_1_7);
            writer.fontMapper = FontMapping.defaultFontMapper();
            writer.options = options;
            writer.ctx = ctx;
            String creator = ExportPdfFormat.getCreator();
            writer.document.addCreator(creator);
            String s = (String)ra.getValue(P_PDF_TITLE, (Binding)Bindings.STRING);
            if (s != null) {
                writer.document.addTitle(s);
            }
            if ((s = (String)ra.getValue(P_PDF_AUTHOR, (Binding)Bindings.STRING)) != null) {
                writer.document.addAuthor(s);
            }
            if ((s = (String)ra.getValue(P_PDF_SUBJECT, (Binding)Bindings.STRING)) != null) {
                writer.document.addSubject(s);
            }
            if ((s = (String)ra.getValue(P_PDF_KEYWORDS, (Binding)Bindings.STRING)) != null) {
                writer.document.addKeywords(s);
            }
            try {
                UnionAccessor ua = (UnionAccessor)ra.getComponent(P_PDF_COMPRESSION);
                int tag = ua.getTag();
                writer.pdfCopy.setCompressionLevel(tag);
                writer.compressionLevel = tag;
            }
            catch (ReferenceException referenceException) {}
            MarginUtils.Margins margins = MarginUtils.MARGINS_10mm;
            Double left = (Double)ra.getValue(P_PAGE_MARGIN_LEFT, (Binding)Bindings.DOUBLE);
            if (left != null) {
                margins = margins.withSide(4, new MarginUtils.Margin(0.0, 0.0, left.doubleValue()));
            }
            if ((right = (Double)ra.getValue(P_PAGE_MARGIN_RIGHT, (Binding)Bindings.DOUBLE)) != null) {
                margins = margins.withSide(8, new MarginUtils.Margin(0.0, 0.0, right.doubleValue()));
            }
            if ((bottom = (Double)ra.getValue(P_PAGE_MARGIN_BOTTOM, (Binding)Bindings.DOUBLE)) != null) {
                margins = margins.withSide(2, new MarginUtils.Margin(0.0, 0.0, bottom.doubleValue()));
            }
            if ((top = (Double)ra.getValue(P_PAGE_MARGIN_TOP, (Binding)Bindings.DOUBLE)) != null) {
                margins = margins.withSide(1, new MarginUtils.Margin(0.0, 0.0, top.doubleValue()));
            }
            String paperName = "A4";
            try {
                UnionAccessor ua = (UnionAccessor)ra.getComponent(P_PAGE_PAPERSIZE);
                int tag = ua.getTag();
                paperName = ua.type().getComponent((int)tag).name;
            }
            catch (ReferenceException referenceException) {}
            PageOrientation pageOrientation = PageOrientation.Portrait;
            try {
                UnionAccessor ua = (UnionAccessor)ra.getComponent(P_PAGE_ORIENTATION);
                int tag = ua.getTag();
                String str = ua.type().getComponent((int)tag).name;
                pageOrientation = PageOrientation.valueOf((String)str);
            }
            catch (ReferenceException referenceException) {}
            PageDesc pd = PageDesc.getByName((String)paperName);
            pd = pd.withOrientation(pageOrientation);
            pd = pd.withMargins(margins);
            writer.margins = margins;
            writer.defaultPageDesc = pd;
            writer.defaultRectangle = ExportPdfWriter.toRectangle(writer.defaultPageDesc);
            writer.document.setPageSize(writer.defaultRectangle);
            writer.document.open();
            writer.cb = writer.pdfCopy.getDirectContent();
            return writer;
        }
        catch (FileNotFoundException e) {
            throw new ExportException(e);
        }
        catch (DocumentException e) {
            throw new ExportException(e);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public Object openFile(ExportContext context, File inputFile, Variant options) throws ExportException {
        try {
            return new ImportPdfReader(inputFile);
        }
        catch (IOException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public List<String> validate(ExportContext context, Variant options) throws ExportException {
        ArrayList<String> problems = new ArrayList<String>();
        try {
            File keystoreFile;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            String keystoreFileName = (String)ra.getValue(P_SIGN_KEYSTORE, (Binding)Bindings.STRING);
            if (keystoreFileName != null && !keystoreFileName.isEmpty() && !(keystoreFile = new File(keystoreFileName)).exists()) {
                problems.add("Keystore file was not found: " + keystoreFile);
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
        return problems;
    }

    @Override
    public void closeFile(ExportContext context, Object handle) throws ExportException {
        if (handle instanceof ImportPdfReader) {
            ImportPdfReader reader = (ImportPdfReader)handle;
            reader.close();
        }
        if (handle instanceof ExportPdfWriter) {
            ExportPdfWriter writer = (ExportPdfWriter)handle;
            writer.close();
            try {
                RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)writer.options);
                String keystoreFileName = (String)ra.getValue(P_SIGN_KEYSTORE, (Binding)Bindings.STRING);
                String keystorePassword = (String)ra.getValue(P_SIGN_KEYSTOREPASSWORD, (Binding)Bindings.STRING);
                String privateKeyPassword = (String)ra.getValue(P_SIGN_PRIVATEKEYPASSWORD, (Binding)Bindings.STRING);
                String signLocation = (String)ra.getValue(P_SIGN_LOCATION, (Binding)Bindings.STRING);
                String signReason = (String)ra.getValue(P_SIGN_REASON, (Binding)Bindings.STRING);
                if (keystoreFileName != null && !keystoreFileName.isEmpty()) {
                    File keystoreFile = new File(keystoreFileName);
                    if (!keystoreFile.exists()) {
                        throw new ExportException("Keystore file was not found: " + keystoreFile);
                    }
                    writer.sign(keystoreFile, keystorePassword, privateKeyPassword, signLocation, signReason);
                }
            }
            catch (AccessorConstructionException e) {
                throw new ExportException(String.valueOf(((Object)((Object)e)).getClass().getName()) + ": " + e.getMessage());
            }
            catch (AccessorException e) {
                throw new ExportException(String.valueOf(((Object)((Object)e)).getClass().getName()) + ": " + e.getMessage());
            }
        }
    }

    @Override
    public void addAttachment(ExportContext ctx, Object handle, List<Content> attachments) throws ExportException {
        ExportPdfWriter writer = (ExportPdfWriter)handle;
        writer.pdfCopy.addViewerPreference(PdfName.USEATTACHMENTS, (PdfObject)PdfBoolean.PDFTRUE);
        for (Content content : attachments) {
            writer.addAttachment(content);
        }
    }

    @Override
    public void savePref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
        try {
            int tag;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            String s = (String)ra.getValue(P_PDF_TITLE, (Binding)Bindings.STRING);
            if (s != null) {
                contentScopeNode.put(P_PDF_TITLE.tail().toString(), s);
            }
            if ((s = (String)ra.getValue(P_PDF_AUTHOR, (Binding)Bindings.STRING)) != null) {
                workbenchScopeNode.put(P_PDF_AUTHOR.tail().toString(), s);
            }
            if ((s = (String)ra.getValue(P_PDF_SUBJECT, (Binding)Bindings.STRING)) != null) {
                contentScopeNode.put(P_PDF_SUBJECT.tail().toString(), s);
            }
            if ((s = (String)ra.getValue(P_PDF_KEYWORDS, (Binding)Bindings.STRING)) != null) {
                contentScopeNode.put(P_PDF_KEYWORDS.tail().toString(), s);
            }
            if ((s = (String)ra.getValue(P_SIGN_KEYSTORE, (Binding)Bindings.STRING)) != null) {
                workbenchScopeNode.put(P_SIGN_KEYSTORE.tail().toString(), s);
            }
            if ((s = (String)ra.getValue(P_SIGN_KEYSTOREPASSWORD, (Binding)Bindings.STRING)) != null) {
                workbenchScopeNode.put(P_SIGN_KEYSTOREPASSWORD.tail().toString(), s);
            }
            if ((s = (String)ra.getValue(P_SIGN_PRIVATEKEYPASSWORD, (Binding)Bindings.STRING)) != null) {
                workbenchScopeNode.put(P_SIGN_PRIVATEKEYPASSWORD.tail().toString(), s);
            }
            if ((s = (String)ra.getValue(P_SIGN_LOCATION, (Binding)Bindings.STRING)) != null) {
                workbenchScopeNode.put(P_SIGN_LOCATION.tail().toString(), s);
            }
            if ((s = (String)ra.getValue(P_SIGN_REASON, (Binding)Bindings.STRING)) != null) {
                workbenchScopeNode.put(P_SIGN_REASON.tail().toString(), s);
            }
            try {
                UnionAccessor ua = (UnionAccessor)ra.getComponent(P_PDF_COMPRESSION);
                int tag2 = ua.getTag();
                workbenchScopeNode.putInt(P_PDF_COMPRESSION.tail().toString(), tag2);
            }
            catch (ReferenceException referenceException) {}
            Double d = (Double)ra.getValue(P_PAGE_MARGIN_LEFT, (Binding)Bindings.DOUBLE);
            if (d != null) {
                contentScopeNode.putDouble(P_PAGE_MARGIN_LEFT.tail().toString(), d.doubleValue());
            }
            if ((d = (Double)ra.getValue(P_PAGE_MARGIN_RIGHT, (Binding)Bindings.DOUBLE)) != null) {
                contentScopeNode.putDouble(P_PAGE_MARGIN_RIGHT.tail().toString(), d.doubleValue());
            }
            if ((d = (Double)ra.getValue(P_PAGE_MARGIN_BOTTOM, (Binding)Bindings.DOUBLE)) != null) {
                contentScopeNode.putDouble(P_PAGE_MARGIN_BOTTOM.tail().toString(), d.doubleValue());
            }
            if ((d = (Double)ra.getValue(P_PAGE_MARGIN_TOP, (Binding)Bindings.DOUBLE)) != null) {
                contentScopeNode.putDouble(P_PAGE_MARGIN_TOP.tail().toString(), d.doubleValue());
            }
            try {
                UnionAccessor ua = (UnionAccessor)ra.getComponent(P_PAGE_PAPERSIZE);
                tag = ua.getTag();
                contentScopeNode.putInt(P_PAGE_PAPERSIZE.tail().toString(), tag);
            }
            catch (ReferenceException referenceException) {}
            try {
                UnionAccessor ua = (UnionAccessor)ra.getComponent(P_PAGE_ORIENTATION);
                tag = ua.getTag();
                contentScopeNode.putInt(P_PAGE_ORIENTATION.tail().toString(), tag);
            }
            catch (ReferenceException referenceException) {}
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public void loadPref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
        try {
            UnionAccessor ua;
            int tag;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            String s = contentScopeNode.get(P_PDF_TITLE.tail().toString(), null);
            if (s != null) {
                ra.setValue(P_PDF_TITLE, (Binding)Bindings.STRING, (Object)s);
            }
            if ((s = workbenchScopeNode.get(P_PDF_AUTHOR.tail().toString(), null)) != null) {
                ra.setValue(P_PDF_AUTHOR, (Binding)Bindings.STRING, (Object)s);
            }
            if ((s = contentScopeNode.get(P_PDF_SUBJECT.tail().toString(), null)) != null) {
                ra.setValue(P_PDF_SUBJECT, (Binding)Bindings.STRING, (Object)s);
            }
            if ((s = contentScopeNode.get(P_PDF_KEYWORDS.tail().toString(), null)) != null) {
                ra.setValue(P_PDF_KEYWORDS, (Binding)Bindings.STRING, (Object)s);
            }
            if ((s = workbenchScopeNode.get(P_SIGN_KEYSTORE.tail().toString(), null)) != null) {
                ra.setValue(P_SIGN_KEYSTORE, (Binding)Bindings.STRING, (Object)s);
            }
            if ((s = workbenchScopeNode.get(P_SIGN_KEYSTOREPASSWORD.tail().toString(), null)) != null) {
                ra.setValue(P_SIGN_KEYSTOREPASSWORD, (Binding)Bindings.STRING, (Object)s);
            }
            if ((s = workbenchScopeNode.get(P_SIGN_PRIVATEKEYPASSWORD.tail().toString(), null)) != null) {
                ra.setValue(P_SIGN_PRIVATEKEYPASSWORD, (Binding)Bindings.STRING, (Object)s);
            }
            if ((s = workbenchScopeNode.get(P_SIGN_LOCATION.tail().toString(), null)) != null) {
                ra.setValue(P_SIGN_LOCATION, (Binding)Bindings.STRING, (Object)s);
            }
            if ((s = workbenchScopeNode.get(P_SIGN_REASON.tail().toString(), null)) != null) {
                ra.setValue(P_SIGN_REASON, (Binding)Bindings.STRING, (Object)s);
            }
            if ((tag = workbenchScopeNode.getInt(P_PDF_COMPRESSION.tail().toString(), -1)) >= 0) {
                try {
                    ua = (UnionAccessor)ra.getComponent(P_PDF_COMPRESSION);
                    ua.setComponentValue(tag, Bindings.VOID, null);
                }
                catch (ReferenceException referenceException) {}
            }
            if ((s = contentScopeNode.get(P_PAGE_MARGIN_LEFT.tail().toString(), null)) != null) {
                ra.setValue(P_PAGE_MARGIN_LEFT, (Binding)Bindings.DOUBLE, (Object)Double.valueOf(s));
            }
            if ((s = contentScopeNode.get(P_PAGE_MARGIN_RIGHT.tail().toString(), null)) != null) {
                ra.setValue(P_PAGE_MARGIN_RIGHT, (Binding)Bindings.DOUBLE, (Object)Double.valueOf(s));
            }
            if ((s = contentScopeNode.get(P_PAGE_MARGIN_TOP.tail().toString(), null)) != null) {
                ra.setValue(P_PAGE_MARGIN_TOP, (Binding)Bindings.DOUBLE, (Object)Double.valueOf(s));
            }
            if ((s = contentScopeNode.get(P_PAGE_MARGIN_BOTTOM.tail().toString(), null)) != null) {
                ra.setValue(P_PAGE_MARGIN_BOTTOM, (Binding)Bindings.DOUBLE, (Object)Double.valueOf(s));
            }
            if ((tag = contentScopeNode.getInt(P_PAGE_PAPERSIZE.tail().toString(), -1)) >= 0) {
                try {
                    ua = (UnionAccessor)ra.getComponent(P_PAGE_PAPERSIZE);
                    ua.setComponentValue(tag, Bindings.VOID, null);
                }
                catch (ReferenceException referenceException) {}
            }
            if ((tag = contentScopeNode.getInt(P_PAGE_ORIENTATION.tail().toString(), -1)) >= 0) {
                try {
                    ua = (UnionAccessor)ra.getComponent(P_PAGE_ORIENTATION);
                    ua.setComponentValue(tag, Bindings.VOID, null);
                }
                catch (ReferenceException referenceException) {}
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public void fillDefaultPrefs(ExportContext ctx, Variant options) throws ExportException {
        try {
            String username;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            IEclipsePreferences instPrefs = InstanceScope.INSTANCE.getNode(PAGE_PLUGIN_ID);
            IEclipsePreferences defaultPrefs = DefaultScope.INSTANCE.getNode(PAGE_PLUGIN_ID);
            String value = ExporterUtils.getPrefString((Preferences)instPrefs, (Preferences)defaultPrefs, P_DEFAULT_PAGE_SIZE);
            if (value != null) {
                try {
                    String[] split;
                    StringTokenizer tok = new StringTokenizer(value);
                    tok.nextToken().trim();
                    tok.nextToken().trim();
                    String orientation = tok.nextToken().trim();
                    if (orientation != null) {
                        try {
                            UnionAccessor ua = (UnionAccessor)ra.getComponent(P_PAGE_ORIENTATION);
                            int index = ua.type().getComponentIndex2(orientation);
                            if (index < 0) {
                                index = 1;
                            }
                            ua.setComponentValue(index, Bindings.VOID, new Object());
                        }
                        catch (ReferenceException referenceException) {}
                    }
                    tok.nextToken().trim();
                    String pagesize = tok.nextToken("\u0001").trim();
                    ExporterUtils.setUnionValue((Accessor)ra, P_PAGE_PAPERSIZE, pagesize);
                    String margins = tok.nextToken().trim();
                    if (margins != null && (split = margins.split(";")).length == 4) {
                        int i = 0;
                        while (i < 4) {
                            String[] tok2 = split[i].split(" ");
                            String cfr_ignored_0 = tok2[0];
                            String cfr_ignored_1 = tok2[1];
                            String diagramAbsolute = tok2[2];
                            ChildReference ref = null;
                            switch (i) {
                                case 0: {
                                    ref = P_PAGE_MARGIN_TOP;
                                    break;
                                }
                                case 1: {
                                    ref = P_PAGE_MARGIN_BOTTOM;
                                    break;
                                }
                                case 2: {
                                    ref = P_PAGE_MARGIN_LEFT;
                                    break;
                                }
                                case 3: {
                                    ref = P_PAGE_MARGIN_RIGHT;
                                }
                            }
                            double margin_mm = Double.valueOf(diagramAbsolute);
                            ra.setValue(ref, (Binding)Bindings.DOUBLE, (Object)margin_mm);
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((username = System.getProperty("user.name")) != null) {
                ra.setValue(P_PDF_AUTHOR, (Binding)Bindings.STRING, (Object)username);
            }
            ra.setValue(P_SIGN_REASON, (Binding)Bindings.STRING, (Object)"Document Created");
            ExporterUtils.setUnionValue((Accessor)ra, P_PDF_COMPRESSION, 9);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
    }

    public static String getCreator() {
        String creator = null;
        IProduct product = Platform.getProduct();
        if (product != null && (creator = product.getDescription()) == null) {
            creator = product.getName();
        }
        if (creator == null) {
            creator = "Simantics";
        }
        return creator;
    }

    public static boolean isPdf(String filename) {
        return PATTERN_PDF.matcher(filename).matches();
    }

    public static boolean isPdf(File file) {
        return PATTERN_PDF.matcher(file.getName()).matches();
    }
}

