/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.scl.ui.console.ErrorAnnotation;
import org.simantics.scl.ui.console.Preferences;
import org.slf4j.Logger;

public abstract class AbstractCommandConsole
extends Composite {
    public static final int HIDE_INPUT = 1;
    public static final String PLUGIN_ID = "org.simantics.scl.ui";
    public static final int COMMAND_HISTORY_SIZE = 50;
    public static final int SASH_HEIGHT = 3;
    LocalResourceManager resourceManager;
    protected final int options;
    StyledText output;
    Sash sash;
    StyledText deco;
    protected StyledText input;
    int userInputHeight = 0;
    int minInputHeight = 0;
    protected Color greenColor;
    protected Color redColor;
    FontRegistry fontRegistry;
    FontDescriptor textFontDescriptor;
    Font textFont;
    ArrayList<String> commandHistory = new ArrayList();
    int commandHistoryPos = 0;
    boolean outputModiLock = false;
    String validatedText;
    Job validationJob = new Job("SCL input validation"){

        protected IStatus run(IProgressMonitor monitor) {
            String text = AbstractCommandConsole.this.validatedText;
            AbstractCommandConsole.this.asyncSetErrorAnnotations(text, AbstractCommandConsole.this.validate(text));
            return Status.OK_STATUS;
        }
    };
    Job preValidationJob = new Job("SCL input validation"){

        protected IStatus run(IProgressMonitor monitor) {
            if (!AbstractCommandConsole.this.input.isDisposed()) {
                AbstractCommandConsole.this.input.getDisplay().asyncExec(() -> {
                    if (!AbstractCommandConsole.this.input.isDisposed()) {
                        AbstractCommandConsole.this.validatedText = AbstractCommandConsole.this.input.getText();
                        AbstractCommandConsole.this.validationJob.setPriority(40);
                        AbstractCommandConsole.this.validationJob.schedule();
                    }
                });
            }
            return Status.OK_STATUS;
        }
    };
    private StringBuilder outputBuffer = new StringBuilder();
    private ArrayList<StyleRange> styleRanges = new ArrayList();
    private volatile boolean outputScheduled = false;
    public static final ErrorAnnotation[] EMPTY_ANNOTATION_ARRAY = new ErrorAnnotation[0];
    String errorAnnotationsForCommand;
    ErrorAnnotation[] errorAnnotations = EMPTY_ANNOTATION_ARRAY;
    IPropertyChangeListener fontRegistryListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            AbstractCommandConsole.this.setTextFont(FontDescriptor.createFrom((FontData[])((FontData[])event.getNewValue())));
        }
    };

    public AbstractCommandConsole(Composite parent, int style, int options) {
        super(parent, style);
        this.options = options;
        this.createControl();
    }

    public boolean setFocus() {
        return this.input != null ? this.input.setFocus() : this.output.setFocus();
    }

    protected boolean canExecuteCommand() {
        return true;
    }

    protected boolean hasOption(int mask) {
        return (this.options & mask) != 0;
    }

    private void createControl() {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
        this.greenColor = this.resourceManager.createColor(new RGB(0, 128, 0));
        this.redColor = this.resourceManager.createColor(new RGB(172, 0, 0));
        this.fontRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        this.fontRegistry.addListener(this.fontRegistryListener);
        FontDescriptor font = FontDescriptor.createFrom((FontData[])this.fontRegistry.getFontData("org.simantics.scl.consolefont"));
        this.setTextFont(font);
        this.setLayout((Layout)new FormLayout());
        this.sash = new Sash((Composite)this, 256);
        this.sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rectangle bounds = AbstractCommandConsole.this.getBounds();
                int max = bounds.y + bounds.height;
                AbstractCommandConsole.this.userInputHeight = max - e.y;
                int actualInputHeight = Math.max(AbstractCommandConsole.this.userInputHeight, AbstractCommandConsole.this.minInputHeight);
                AbstractCommandConsole.this.sash.setBounds(e.x, max - actualInputHeight, e.width, e.height);
                AbstractCommandConsole.this.setInputHeight(actualInputHeight);
            }
        });
        this.output = new StyledText((Composite)this, 770);
        this.output.setFont(this.textFont);
        this.output.setLayoutData((Object)this.formData(0, this.sash, 0, 100));
        this.output.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (AbstractCommandConsole.this.outputModiLock) {
                    return;
                }
                if (AbstractCommandConsole.this.input != null) {
                    AbstractCommandConsole.this.input.append(e.text);
                    AbstractCommandConsole.this.input.setFocus();
                    AbstractCommandConsole.this.input.setCaretOffset(AbstractCommandConsole.this.input.getText().length());
                }
                e.doit = false;
            }
        });
        if (this.hasOption(1)) {
            this.sash.setLayoutData((Object)this.formData(new Tuple2((Object)100, (Object)0), null, 0, 100, 0));
            this.layout(true);
        } else {
            this.createInputArea();
        }
        this.readPreferences();
        this.addListener(12, event -> {
            if (this.fontRegistry != null) {
                this.fontRegistry.removeListener(this.fontRegistryListener);
            }
            try {
                this.writePreferences();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    protected void createInputArea() {
        this.deco = new StyledText((Composite)this, 10);
        this.deco.setFont(this.textFont);
        this.deco.setEnabled(false);
        GC gc = new GC((Drawable)this.deco);
        int inputLeftPos = gc.getFontMetrics().getAverageCharWidth() * 2;
        gc.dispose();
        this.deco.setText(">");
        this.deco.setLayoutData((Object)this.formData(this.sash, 100, 0, new Tuple2((Object)0, (Object)inputLeftPos)));
        this.input = new StyledText((Composite)this, 2);
        this.input.setFont(this.textFont);
        this.input.setLayoutData((Object)this.formData(this.sash, 100, new Tuple2((Object)0, (Object)inputLeftPos), 100));
        this.adjustInputSize("");
        this.input.addVerifyKeyListener(event -> {
            switch (event.keyCode) {
                case 13: 
                case 0x1000050: {
                    if ((event.stateMask & 0x40000) != 0) break;
                    if (this.canExecuteCommand()) {
                        this.execute();
                    }
                    event.doit = false;
                    break;
                }
                case 0x1000001: 
                case 0x1000002: {
                    if ((event.stateMask & 0x40000) == 0) break;
                    int targetHistoryPos = this.commandHistoryPos;
                    if (event.keyCode == 0x1000001) {
                        if (this.commandHistoryPos <= 0) {
                            return;
                        }
                        --targetHistoryPos;
                    } else {
                        if (this.commandHistoryPos >= this.commandHistory.size() - 1) {
                            return;
                        }
                        ++targetHistoryPos;
                    }
                    this.setInputText(this.commandHistory.get(targetHistoryPos));
                    this.commandHistoryPos = targetHistoryPos;
                    event.doit = false;
                }
            }
        });
        this.input.addVerifyListener(e -> {
            if (e.text.contains("\n")) {
                int lineId = this.input.getLineAtOffset(e.start);
                int lineOffset = this.input.getOffsetAtLine(lineId);
                int indentAmount = 0;
                while (lineOffset + indentAmount < this.input.getCharCount() && this.input.getTextRange(lineOffset + indentAmount, 1).equals(" ")) {
                    ++indentAmount;
                }
                StringBuilder indent = new StringBuilder();
                indent.append('\n');
                int i = 0;
                while (i < indentAmount) {
                    indent.append(' ');
                    ++i;
                }
                e.text = e.text.replace("\n", indent);
            }
        });
        this.input.addModifyListener(e -> {
            this.adjustInputSize(this.input.getText());
            this.commandHistoryPos = this.commandHistory.size();
        });
        Listener hoverListener = new Listener(){
            DefaultToolTip toolTip;
            int min;
            int max;
            boolean toolTipVisible;
            {
                this.toolTip = new DefaultToolTip((Control)AbstractCommandConsole.this.input, 1, true);
                this.toolTipVisible = false;
            }

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 32: {
                        int offset = AbstractCommandConsole.this.getOffsetInInput(e.x, e.y);
                        if (offset == -1) {
                            return;
                        }
                        this.min = Integer.MIN_VALUE;
                        this.max = Integer.MAX_VALUE;
                        StringBuilder description = new StringBuilder();
                        boolean first = true;
                        ErrorAnnotation[] errorAnnotationArray = AbstractCommandConsole.this.errorAnnotations;
                        int n = AbstractCommandConsole.this.errorAnnotations.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ErrorAnnotation annotation = errorAnnotationArray[n2];
                            if (annotation.start <= offset && annotation.end > offset) {
                                this.min = Math.max(this.min, annotation.start);
                                this.max = Math.max(this.min, annotation.end);
                                if (first) {
                                    first = false;
                                } else {
                                    description.append('\n');
                                }
                                description.append(annotation.description);
                            }
                            ++n2;
                        }
                        if (this.min != Integer.MIN_VALUE) {
                            Rectangle bounds = AbstractCommandConsole.this.input.getTextBounds(this.min, this.max - 1);
                            this.toolTip.setText(description.toString());
                            this.toolTip.show(new Point(bounds.x, bounds.y + bounds.height));
                            this.toolTipVisible = true;
                        }
                        return;
                    }
                    case 5: {
                        int offset;
                        if (this.toolTipVisible && ((offset = AbstractCommandConsole.this.getOffsetInInput(e.x, e.y)) < this.min || offset >= this.max)) {
                            this.toolTip.hide();
                            this.toolTipVisible = false;
                            return;
                        }
                        return;
                    }
                    case 7: {
                        if (this.toolTipVisible) {
                            this.toolTip.hide();
                            this.toolTipVisible = false;
                        }
                        return;
                    }
                }
            }
        };
        this.input.addListener(32, hoverListener);
        this.input.addListener(5, hoverListener);
        this.input.addListener(7, hoverListener);
    }

    private FormData formData(Object top, Object bottom, Object left, Object right) {
        return this.formData(top, bottom, left, right, null);
    }

    private FormData formData(Object top, Object bottom, Object left, Object right, Integer height) {
        FormData d = new FormData();
        d.top = this.formAttachment(top);
        d.bottom = this.formAttachment(bottom);
        d.left = this.formAttachment(left);
        d.right = this.formAttachment(right);
        d.height = height != null ? height : -1;
        return d;
    }

    private FormAttachment formAttachment(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Control) {
            return new FormAttachment((Control)o);
        }
        if (o instanceof Integer) {
            return new FormAttachment(((Integer)o).intValue());
        }
        if (o instanceof Tuple2) {
            Tuple2 t = (Tuple2)o;
            return new FormAttachment(((Integer)t.c0).intValue(), ((Integer)t.c1).intValue());
        }
        throw new IllegalArgumentException("argument not supported: " + o);
    }

    private int getOffsetInInput(int x, int y) {
        Rectangle rect;
        int offset;
        try {
            offset = this.input.getOffsetAtLocation(new Point(x, y));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
        if (offset == this.input.getText().length()) {
            --offset;
        } else if (offset > 0 && !(rect = this.input.getTextBounds(offset, offset)).contains(x, y)) {
            --offset;
        }
        return offset;
    }

    public void setInputText(String text) {
        if (this.input == null) {
            return;
        }
        this.input.setText(text);
        this.input.setCaretOffset(text.length());
        this.adjustInputSize(text);
    }

    private void asyncValidate() {
        if (!this.input.getText().equals(this.errorAnnotationsForCommand)) {
            this.preValidationJob.cancel();
            this.preValidationJob.setPriority(40);
            this.preValidationJob.schedule(500L);
        }
    }

    private static int rowCount(String text) {
        int rowCount = 1;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\n') {
                ++rowCount;
            }
            ++i;
        }
        return rowCount;
    }

    private void adjustInputSize(String text) {
        int lineHeight = this.input.getLineHeight();
        int height = AbstractCommandConsole.rowCount(text) * lineHeight + 3;
        if (height != this.minInputHeight) {
            this.minInputHeight = height;
            this.setInputHeight(Math.max(this.minInputHeight, this.userInputHeight));
        }
    }

    private void setInputHeight(int inputHeight) {
        this.sash.setLayoutData((Object)this.formData(new Tuple2((Object)100, (Object)(-inputHeight)), null, 0, 100, 3));
        this.layout(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendOutput(String text, Color foreground, Color background) {
        StringBuilder stringBuilder = this.outputBuffer;
        synchronized (stringBuilder) {
            this.styleRanges.add(new StyleRange(this.outputBuffer.length(), text.length(), foreground, background));
            this.outputBuffer.append(text);
        }
        if (!this.outputScheduled) {
            this.outputScheduled = true;
            Display display = Display.getDefault();
            if (display.isDisposed()) {
                return;
            }
            display.asyncExec(() -> {
                StyleRange[] styleRangeArray;
                String outputText;
                if (this.output.isDisposed()) {
                    return;
                }
                StringBuilder stringBuilder = this.outputBuffer;
                synchronized (stringBuilder) {
                    this.outputScheduled = false;
                    outputText = this.outputBuffer.toString();
                    this.outputBuffer = new StringBuilder();
                    styleRangeArray = this.styleRanges.toArray(new StyleRange[this.styleRanges.size()]);
                    this.styleRanges.clear();
                }
                int pos = this.output.getCharCount();
                this.outputModiLock = true;
                this.output.replaceTextRange(pos, 0, outputText);
                this.outputModiLock = false;
                StyleRange[] styleRangeArray2 = styleRangeArray;
                int n = styleRangeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StyleRange styleRange = styleRangeArray2[n2];
                    styleRange.start += pos;
                    this.output.setStyleRange(styleRange);
                    ++n2;
                }
                this.output.setCaretOffset(this.output.getCharCount());
                this.output.showSelection();
            });
        }
    }

    private void execute() {
        String command = this.input.getText().trim();
        if (command.isEmpty()) {
            return;
        }
        if (this.commandHistory.isEmpty() || !this.commandHistory.get(this.commandHistory.size() - 1).equals(command)) {
            this.commandHistory.add(command);
            if (this.commandHistory.size() > 100) {
                this.commandHistory = new ArrayList<String>(this.commandHistory.subList(50, 100));
            }
        }
        this.commandHistoryPos = this.commandHistory.size();
        this.input.setText("");
        this.execute(command);
    }

    private void syncSetErrorAnnotations(String forCommand, ErrorAnnotation[] annotations) {
        this.errorAnnotationsForCommand = forCommand;
        this.errorAnnotations = annotations;
        StyleRange clearRange = new StyleRange(0, forCommand.length(), null, null);
        this.input.setStyleRange(clearRange);
        int i = 0;
        while (i < annotations.length) {
            ErrorAnnotation annotation = annotations[i];
            StyleRange range = new StyleRange(annotation.start, annotation.end - annotation.start, null, null);
            range.underline = true;
            range.underlineColor = this.redColor;
            range.underlineStyle = 3;
            try {
                this.input.setStyleRange(range);
            }
            catch (IllegalArgumentException e) {
                range.start = 0;
                range.length = 1;
                this.input.setStyleRange(range);
                this.getLogger().error("The following error message didn't have a proper location: {}", (Object)annotation.description, (Object)e);
            }
            ++i;
        }
    }

    private void asyncSetErrorAnnotations(String forCommand, ErrorAnnotation[] annotations) {
        if (this.input.isDisposed()) {
            return;
        }
        this.input.getDisplay().asyncExec(() -> {
            if (this.input.isDisposed()) {
                return;
            }
            if (!this.input.getText().equals(forCommand)) {
                return;
            }
            this.syncSetErrorAnnotations(forCommand, annotations);
        });
    }

    private boolean readPreferences() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        String commandHistoryPref = store.getString("COMMAND_HISTORY");
        Deque<String> recentImportPaths = Preferences.decodePaths(commandHistoryPref);
        this.commandHistory = new ArrayList<String>(recentImportPaths);
        this.commandHistoryPos = this.commandHistory.size();
        return true;
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        store.putValue("COMMAND_HISTORY", Preferences.encodePaths(this.commandHistory));
        if (store.needsSaving()) {
            store.save();
        }
    }

    public abstract void execute(String var1);

    public abstract ErrorAnnotation[] validate(String var1);

    public void clear() {
        this.outputModiLock = true;
        this.output.setText("");
        this.outputModiLock = false;
    }

    public StyledText getOutputWidget() {
        return this.output;
    }

    private void setTextFont(FontDescriptor font) {
        FontDescriptor oldFontDesc = this.textFontDescriptor;
        this.textFont = this.resourceManager.createFont(font);
        this.textFontDescriptor = font;
        this.applyTextFont(this.textFont);
        if (oldFontDesc != null) {
            this.resourceManager.destroyFont(oldFontDesc);
        }
    }

    private void applyTextFont(Font font) {
        if (this.output != null) {
            this.output.setFont(font);
        }
        if (this.deco != null) {
            this.deco.setFont(font);
        }
        if (this.input != null) {
            this.input.setFont(font);
            this.adjustInputSize(this.input.getText());
        }
    }

    public abstract Logger getLogger();
}

