/*
 * Decompiled with CFR 0.152.
 */
package winterwell.markdown.views;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.part.ViewPart;
import winterwell.markdown.editors.ActionBarContributor;
import winterwell.markdown.editors.MarkdownEditor;
import winterwell.markdown.pagemodel.MarkdownPage;

public class MarkdownPreview
extends ViewPart {
    public static MarkdownPreview preview = null;
    private Browser viewer = null;

    public MarkdownPreview() {
        preview = this;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new Browser(parent, 2);
    }

    public void setFocus() {
        if (this.viewer == null) {
            return;
        }
        this.viewer.setFocus();
        this.update();
    }

    public void update() {
        block6: {
            if (this.viewer == null) {
                return;
            }
            try {
                IEditorPart editor = ActionBarContributor.getActiveEditor();
                if (!(editor instanceof MarkdownEditor)) {
                    this.viewer.setText("");
                    return;
                }
                MarkdownEditor ed = (MarkdownEditor)editor;
                MarkdownPage page = ed.getMarkdownPage();
                String html = page.html();
                html = this.addBaseURL(editor, html);
                if (page != null) {
                    this.viewer.setText(html);
                } else {
                    this.viewer.setText("");
                }
            }
            catch (Exception ex) {
                System.out.println(ex);
                if (this.viewer == null || this.viewer.isDisposed()) break block6;
                this.viewer.setText(ex.getMessage());
            }
        }
    }

    private String addBaseURL(IEditorPart editor, String html) {
        try {
            IPathEditorInput input = (IPathEditorInput)editor.getEditorInput();
            IPath path = input.getPath();
            path = path.removeLastSegments(1);
            File f = path.toFile();
            URI fileURI = f.toURI();
            String html2 = "<html><head><base href='" + fileURI + "' /></head><body>\r\n" + html + "\r\n</body></html>";
            return html2;
        }
        catch (Exception exception) {
            return html;
        }
    }
}

