/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.internal;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.function.Consumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.simantics.UnhandledExceptionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnhandledExceptionServiceImpl
implements UnhandledExceptionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnhandledExceptionServiceImpl.class);
    private static ServiceRegistration<?> service = null;
    private final List<Consumer<Throwable>> handlers = new ArrayList<Consumer<Throwable>>();

    public static synchronized void initialize(BundleContext context) {
        if (service == null) {
            service = context.registerService(UnhandledExceptionService.class.getName(), (Object)new UnhandledExceptionServiceImpl(), new Hashtable());
        }
    }

    public static synchronized void close() {
        if (service != null) {
            service.unregister();
            service = null;
        }
    }

    @Override
    public synchronized void registerHandler(Consumer<Throwable> handler) {
        this.handlers.add(handler);
    }

    @Override
    public synchronized void handle(Throwable t) {
        for (Consumer<Throwable> handler : this.handlers) {
            try {
                handler.accept(t);
            }
            catch (Exception e) {
                this.handleException(handler, e);
            }
            catch (LinkageError e) {
                this.handleException(handler, e);
            }
            catch (AssertionError e) {
                this.handleException(handler, (Throwable)((Object)e));
            }
        }
    }

    protected void handleException(Object source, Throwable t) {
        LOGGER.error("{}: Unhandled exception handler {} caused unexpected exception", new Object[]{this.getClass().getSimpleName(), source, t});
    }
}

