/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingProgressMonitor
extends NullProgressMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimingProgressMonitor.class);
    private final long start = System.nanoTime();

    private void log(String msg) {
        LOGGER.info(msg + " @ " + (double)(System.nanoTime() - this.start) * 1.0E-9);
    }

    public void worked(int work) {
        this.log("worked(" + work + ")");
    }

    public void subTask(String name) {
        this.log("subTask(" + name + ")");
    }

    public void setTaskName(String name) {
        this.log("setTaskName(" + name + ")");
    }

    public void setCanceled(boolean value) {
        this.log("setCanceled(" + value + ")");
        super.setCanceled(value);
    }

    public boolean isCanceled() {
        this.log("isCanceled()");
        return super.isCanceled();
    }

    public void internalWorked(double work) {
        this.log("internalWorked(" + work + ")");
    }

    public void done() {
        this.log("done()");
    }

    public void beginTask(String name, int totalWork) {
        this.log("beginTask(" + name + ", " + totalWork + ")");
    }
}

