/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Development {
    private static final Logger LOGGER = LoggerFactory.getLogger(Development.class);
    public static TreeMap<String, Integer> histogram = new TreeMap();
    public static final boolean DEVELOPMENT = false;
    public static final String PRINT = "Development.print";
    public static String LOG_FILE = "development.log";
    public static String REPORT_FILE = "development.report";
    private static String breakLine;
    static OutputStream log;
    private static int largest;
    private static Map<String, Integer> logHistogram;
    private static Map<String, LinkedList<Exception>> logTrace;
    private static final HashMap<String, Variant> properties;
    private static final CopyOnWriteArrayList<DevelopmentListener> listeners;

    static {
        largest = 0;
        logHistogram = new HashMap<String, Integer>();
        logTrace = new HashMap<String, LinkedList<Exception>>();
        properties = new HashMap();
        listeners = new CopyOnWriteArrayList();
    }

    public static void breakOnLine() {
        new Exception("Development breakLine breakpoint was hit.").printStackTrace();
    }

    public static void log(String line) {
    }

    public static void developmentSetBreakLine(String line) {
        breakLine = line;
    }

    public static void developmentClearBreakLine(String line) {
        breakLine = null;
    }

    public static void developmentClear() throws IOException {
        boolean hadLog;
        boolean bl = hadLog = log != null;
        if (hadLog) {
            log.close();
        }
        Files.write(new File(LOG_FILE).toPath(), new byte[0], StandardOpenOption.TRUNCATE_EXISTING);
        if (hadLog) {
            log = new BufferedOutputStream(new FileOutputStream(LOG_FILE));
        }
    }

    public static String developmentReportPR() throws IOException {
        return Development.developmentReportPrefix("PR ");
    }

    public static String developmentReportPQ() throws IOException {
        return Development.developmentReportPrefix("PQ ");
    }

    public static String developmentReportPrefix(String prefix) throws IOException {
        HashMap histogram = new HashMap();
        Files.lines(new File(LOG_FILE).toPath()).forEach(line -> {
            if (line.startsWith(prefix)) {
                String req;
                Integer i = (Integer)histogram.get(req = line.substring(2));
                histogram.put(req, i == null ? 1 : i + 1);
            }
        });
        StringBuilder sb = new StringBuilder(16384);
        histogram.entrySet().stream().sorted((e1, e2) -> {
            int i = -Integer.compare((Integer)e1.getValue(), (Integer)e2.getValue());
            if (i != 0) {
                return i;
            }
            return ((String)e1.getKey()).compareTo((String)e2.getKey());
        }).forEach(e -> {
            sb.append(e.getValue());
            sb.append(' ');
            sb.append((String)e.getKey());
            sb.append('\n');
        });
        FileUtils.writeFile(new File(REPORT_FILE), sb.toString().getBytes());
        return sb.toString();
    }

    public static void addListener(DevelopmentListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(DevelopmentListener listener) {
        listeners.remove(listener);
    }

    public static void dispatchEvent(Object event) {
        for (DevelopmentListener listener : listeners) {
            listener.handle(event);
        }
    }

    public static void setProperty(String name, Object value, Binding binding) {
        assert (name != null);
        assert (binding != null);
        try {
            binding.assertInstaceIsValid(value);
        }
        catch (BindingException e) {
            throw new RuntimeException(e);
        }
        properties.put(name, new Variant(binding, value));
    }

    public static <T> T getProperty(String name, Binding binding) {
        Variant value = properties.get(name);
        if (value == null) {
            return null;
        }
        try {
            return (T)value.getValue(binding);
        }
        catch (AdaptException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isTrue(String name) {
        Boolean value = (Boolean)Development.getProperty(name, (Binding)Bindings.BOOLEAN);
        return value != null && value != false;
    }

    public static Map<String, Variant> getProperties() {
        return properties;
    }

    public static void recordHistogram(Object o) {
        String key;
        Integer i = histogram.get(key = o.toString());
        histogram.put(key, i == null ? 1 : i + 1);
    }

    public static interface DevelopmentListener {
        public void handle(Object var1);
    }
}

