/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * Created on 16.12.2005
 * 
 */
package org.simantics.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;


/**
 * DataContainer is used as return argument
 * 
 * @author Toni Kalajainen
 */
public final class DataContainer<T> implements Container<T>, Collection<T> {

    private T data;

    public static <T> DataContainer<T> make(T t) {
        return new DataContainer<T>(t);
    }

    public DataContainer() {
    }

    public DataContainer(T initialData) {
        this.data = initialData;
    }

    public boolean isEmpty() {
        return data == null;
    }

    public void set(T value) {
        data = value;
    }

    public T get() {
        return data;
    }

    public boolean hasContent() {
        return data != null;
    }

    @Override
    public boolean add(T arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {

        return new Iterator<T>() {

            private T value = data;

            @Override
            public boolean hasNext() {
                return value != null;
            }

            @Override
            public T next() {
                T result = value;
                value = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };

    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return data != null ? 1 : 0;
    }

    @Override
    public Object[] toArray() {
        return new Object[] { data };
    }

    @SuppressWarnings("unchecked")
    @Override
    public <K> K[] toArray(K[] a) {
        int size = size();
        if (a.length < size)
            a = (K[]) Array.newInstance(a.getClass().getComponentType(), 1);
        if (size > 0)
            a[0] = (K) data;
        for (int i = size; i < a.length; ++i)
            a[i] = null;
        return a;
    }

}
