/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.editor;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.workbench.action.IWorkbenchActionHints;
import org.simantics.ui.workbench.action.ResourceEditorAdapterAction;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.EditorRegistry;
import org.simantics.utils.ui.action.IPriorityAction;

public class OpenDefaultEditor
implements IDoubleClickAction {
    @Override
    public void doubleClickEvent(DoubleClickEvent e) {
        ReadGraph g = e.getGraph();
        Object r = e.getResource();
        Boolean remember = (Boolean)e.getHintContext().getHint(IWorkbenchActionHints.KEY_REMEMBER);
        final boolean rememberChoice = remember != null ? remember : false;
        Boolean ask = (Boolean)e.getHintContext().getHint(IWorkbenchActionHints.KEY_ALWAYS_ASK);
        boolean alwaysAsk = ask != null ? ask : false;
        EditorAdapter primaryAdapter = EditorRegistry.getInstance().getMappings().get(r);
        if (!alwaysAsk && primaryAdapter != null) {
            e.add((IPriorityAction)new ResourceEditorAdapterAction(primaryAdapter, r));
        } else {
            try {
                EditorAdapter[] editorAdapters;
                EditorAdapter[] editorAdapterArray = editorAdapters = EditorRegistry.getInstance().getAdaptersFor(g, r);
                int n = editorAdapters.length;
                int n2 = 0;
                while (n2 < n) {
                    final EditorAdapter a = editorAdapterArray[n2];
                    e.add((IPriorityAction)new ResourceEditorAdapterAction(a, r){

                        @Override
                        protected void safeRun() throws Exception {
                            super.safeRun();
                            if (rememberChoice && a.getPriority() >= 0) {
                                EditorRegistry.getInstance().getMappings().put(this.getResource(), this.getAdapter());
                            }
                        }
                    });
                    ++n2;
                }
            }
            catch (DatabaseException databaseException) {}
        }
    }
}

