/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.e4;

import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.simantics.db.Resource;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class E4WorkbenchUtils {
    private static final String[] KEYS_RESOURCE = new String[]{"keyResource"};
    private static final String TAG_EDITOR = "Editor";
    public static final String EDITOR_PART_STACK_ID = "org.eclipse.e4.primaryDataStack";
    public static final String EDITOR_AREA_ID = "org.eclipse.ui.editorss";

    public static MPart openEditor(String editorId, String contributionURI, String iconURI, String inputId, Map<String, Object> inputMap) {
        if (editorId == null) {
            throw new NullPointerException("null editor ID");
        }
        if (contributionURI == null) {
            throw new NullPointerException("null contributionURI");
        }
        if (inputId == null) {
            throw new NullPointerException("null input ID");
        }
        if (inputMap == null) {
            throw new NullPointerException("null input map");
        }
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        EModelService modelService = (EModelService)context.get(EModelService.class);
        EPartService partService = (EPartService)context.get(EPartService.class);
        MApplication app = (MApplication)context.get(MApplication.class);
        String editorID = editorId + "_" + inputId;
        List parts = modelService.findElements((MUIElement)app, editorID, MPart.class, null);
        MPart editor = null;
        if (parts == null || parts.isEmpty()) {
            editor = (MPart)modelService.createModelElement(MPart.class);
            editor.setElementId(editorID);
            editor.setContributionURI(contributionURI);
            if (iconURI != null) {
                editor.setIconURI(iconURI);
            }
            editor.setCloseable(true);
            editor.getTags().add(TAG_EDITOR);
            editor.getTransientData().putAll(inputMap);
            MPartStack stack = E4WorkbenchUtils.getEditorPartStack(modelService, app);
            stack.getChildren().add(editor);
        } else {
            editor = (MPart)parts.get(0);
        }
        partService.showPart(editor, EPartService.PartState.ACTIVATE);
        return editor;
    }

    public static MPart openEditor(String editorId, String contributionURI, String iconURI, Resource input) {
        String inputId = Long.toString(input.getResourceId());
        ArrayMap inputMap = ArrayMap.make((Object[])KEYS_RESOURCE, (Object[])new Object[]{input});
        return E4WorkbenchUtils.openEditor(editorId, contributionURI, iconURI, inputId, (Map<String, Object>)inputMap);
    }

    public static void closeEditor(String editorElementId) {
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        EModelService modelService = (EModelService)context.get(EModelService.class);
        MApplication app = (MApplication)context.get(MApplication.class);
        modelService.findElements((MUIElement)app, editorElementId, MPart.class, null).forEach(p -> ((EPartService)p.getContext().get(EPartService.class)).hidePart(p));
    }

    public static void activatePart(MPart part) {
        EPartService partService = (EPartService)part.getContext().get(EPartService.class);
        partService.activate(part);
    }

    public static MPartStack getEditorPartStack(EModelService modelService, MApplication app) {
        MPartStack stack = (MPartStack)modelService.find(EDITOR_PART_STACK_ID, (MUIElement)app);
        if (stack == null) {
            MArea editorArea = null;
            MUIElement area = modelService.find(EDITOR_AREA_ID, (MUIElement)app);
            if (area instanceof MPlaceholder) {
                editorArea = (MArea)((MPlaceholder)area).getRef();
            } else if (area instanceof MArea) {
                editorArea = (MArea)area;
            }
            if (editorArea == null) {
                throw new IllegalStateException("Shared editor area (org.eclipse.ui.editorss) not found in application model");
            }
            for (MPartSashContainerElement container : editorArea.getChildren()) {
                if (!(container instanceof MPartStack)) continue;
                stack = (MPartStack)container;
                break;
            }
        }
        if (stack == null) {
            throw new IllegalStateException("Could not find part stack under editor area.");
        }
        return stack;
    }

    public static void openAndShowPart(MPart part) {
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        EPartService partService = (EPartService)context.get(EPartService.class);
        if (!partService.isPartVisible(part)) {
            partService.showPart(part, EPartService.PartState.ACTIVATE);
        } else {
            partService.activate(part);
        }
    }

    public static void openAndShowPart(String partId) {
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        EPartService partService = (EPartService)context.get(EPartService.class);
        partService.showPart(partId, EPartService.PartState.ACTIVATE);
    }

    public static MPart getMPartById(String partId) {
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        EPartService partService = (EPartService)context.get(EPartService.class);
        MPart part = partService.findPart(partId);
        if (part == null) {
            part = partService.createPart(partId);
        }
        return part;
    }

    public static MCommand getMCommandById(String id) {
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        MApplication application = (MApplication)context.get(MApplication.class);
        for (MCommand command : application.getCommands()) {
            if (!id.equals(command.getElementId())) continue;
            return command;
        }
        return null;
    }

    public static IEditorPart getActiveIEditorPart(MPart mActiveEditorPart) {
        IEditorPart activeEditor = null;
        if (mActiveEditorPart != null) {
            Object editor = mActiveEditorPart.getObject();
            if (editor instanceof CompatibilityEditor) {
                CompatibilityEditor compEditor = (CompatibilityEditor)editor;
                activeEditor = compEditor.getEditor();
            } else {
                activeEditor = WorkbenchUtils.getActiveEditor();
            }
        }
        return activeEditor;
    }
}

