/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.Container;

public class ResourceAdaptionUtils {
    public static Resource adaptToResource(Object o) {
        if (o instanceof Container) {
            Object obj = ((Container)o).get();
            if (obj instanceof Resource) {
                return (Resource)obj;
            }
        } else if (o instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)o;
            Resource r = (Resource)a.getAdapter(Resource.class);
            return r;
        }
        return null;
    }

    public static Resource adaptToResource(ReadGraph graph, Object o) throws DatabaseException {
        IAdaptable a;
        Variable var;
        Resource r = ResourceAdaptionUtils.adaptToResource(o);
        if (r != null) {
            return r;
        }
        if (o instanceof Variable) {
            Variable var2 = (Variable)o;
            return var2.getPossibleRepresents(graph);
        }
        if (o instanceof IAdaptable && (var = (Variable)(a = (IAdaptable)o).getAdapter(Variable.class)) != null) {
            return var.getPossibleRepresents(graph);
        }
        return null;
    }

    private static Resource[] toResources(IStructuredSelection iss) {
        if (iss == null || iss.isEmpty()) {
            return Resource.NONE;
        }
        ArrayList<Resource> list = new ArrayList<Resource>(iss.size());
        for (Object o : iss) {
            Resource r = ResourceAdaptionUtils.adaptToResource(o);
            if (r == null) continue;
            list.add(r);
        }
        return list.toArray(Resource.NONE);
    }

    public static Resource toSingleResource(Object o) {
        if (o instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)o;
            if (iss.size() != 1) {
                return null;
            }
            Object element = iss.getFirstElement();
            return ResourceAdaptionUtils.adaptToResource(element);
        }
        return ResourceAdaptionUtils.adaptToResource(o);
    }

    public static Resource toSingleResource(ReadGraph graph, Object o) throws DatabaseException {
        if (o instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)o;
            if (iss.size() != 1) {
                return null;
            }
            Object element = iss.getFirstElement();
            return ResourceAdaptionUtils.adaptToResource(graph, element);
        }
        return ResourceAdaptionUtils.adaptToResource(graph, o);
    }

    public static Resource[] toResources(Object o) {
        Resource[] resourceArray;
        if (o instanceof IStructuredSelection) {
            return ResourceAdaptionUtils.toResources((IStructuredSelection)o);
        }
        Resource r = ResourceAdaptionUtils.adaptToResource(o);
        if (r == null) {
            resourceArray = Resource.NONE;
        } else {
            Resource[] resourceArray2 = new Resource[1];
            resourceArray = resourceArray2;
            resourceArray2[0] = r;
        }
        return resourceArray;
    }

    private static ResourceArray adaptToResourceArray(Object o) {
        if (o instanceof Container) {
            Object obj = ((Container)o).get();
            if (obj instanceof ResourceArray) {
                return (ResourceArray)obj;
            }
            if (obj instanceof Resource) {
                return new ResourceArray(new Resource[]{(Resource)obj});
            }
        }
        if (o instanceof Resource[]) {
            return new ResourceArray((Resource[])o);
        }
        if (o instanceof ResourceArray) {
            return (ResourceArray)o;
        }
        if (o instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)o;
            ResourceArray r = (ResourceArray)a.getAdapter(ResourceArray.class);
            if (r != null) {
                return r;
            }
            Resource[] r3 = (Resource[])a.getAdapter(Resource[].class);
            if (r3 != null) {
                return new ResourceArray(r3);
            }
            Resource r2 = (Resource)a.getAdapter(Resource.class);
            if (r2 != null) {
                return new ResourceArray(new Resource[]{r2});
            }
        }
        return null;
    }

    private static ResourceArray[] adaptToResourceArrays(Object o) {
        ResourceArray[] resourceArrayArray;
        IAdaptable a;
        ResourceArray[] ras;
        if (o instanceof ResourceArray[]) {
            return (ResourceArray[])o;
        }
        if (o instanceof IAdaptable && (ras = (ResourceArray[])(a = (IAdaptable)o).getAdapter(ResourceArray[].class)) != null) {
            return ras;
        }
        ResourceArray ra = ResourceAdaptionUtils.adaptToResourceArray(o);
        if (ra != null) {
            ResourceArray[] resourceArrayArray2 = new ResourceArray[1];
            resourceArrayArray = resourceArrayArray2;
            resourceArrayArray2[0] = ra;
        } else {
            resourceArrayArray = null;
        }
        return resourceArrayArray;
    }

    private static ResourceArray[] toResourceArrays(IStructuredSelection iss) {
        if (iss == null || iss.isEmpty()) {
            return ResourceArray.NONE;
        }
        ArrayList<ResourceArray> list = new ArrayList<ResourceArray>(iss.size());
        for (Object o : iss) {
            ResourceArray[] r = ResourceAdaptionUtils.adaptToResourceArrays(o);
            if (r == null) continue;
            ResourceArray[] resourceArrayArray = r;
            int n = r.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceArray ra = resourceArrayArray[n2];
                list.add(ra);
                ++n2;
            }
        }
        return list.toArray(ResourceArray.NONE);
    }

    public static ResourceArray toSingleResourceArray(Object o) {
        if (o instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)o;
            if (iss.size() != 1) {
                return null;
            }
            Object element = iss.getFirstElement();
            return ResourceAdaptionUtils.adaptToResourceArray(element);
        }
        return ResourceAdaptionUtils.adaptToResourceArray(o);
    }

    public static ResourceArray[] toResourceArrays(Object o) {
        ResourceArray[] resourceArrayArray;
        if (o instanceof List) {
            List list = (List)o;
            ArrayList<ResourceArray> out = new ArrayList<ResourceArray>(list.size());
            for (Object i : list) {
                ResourceArray[] r = ResourceAdaptionUtils.adaptToResourceArrays(i);
                if (r == null) continue;
                ResourceArray[] resourceArrayArray2 = r;
                int n = r.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceArray ra = resourceArrayArray2[n2];
                    out.add(ra);
                    ++n2;
                }
            }
            return out.toArray(ResourceArray.NONE);
        }
        if (o instanceof IStructuredSelection) {
            return ResourceAdaptionUtils.toResourceArrays((IStructuredSelection)o);
        }
        ResourceArray r = ResourceAdaptionUtils.adaptToResourceArray(o);
        if (r == null) {
            resourceArrayArray = ResourceArray.NONE;
        } else {
            ResourceArray[] resourceArrayArray3 = new ResourceArray[1];
            resourceArrayArray = resourceArrayArray3;
            resourceArrayArray3[0] = r;
        }
        return resourceArrayArray;
    }

    public static Resource toSingleWorkbenchResource() {
        return ResourceAdaptionUtils.toSingleResource(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection());
    }
}

