/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IMemento;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.ui.dnd.ResourceTransferData;
import org.simantics.utils.ui.workbench.StringMemento;

public class ResourceTransferUtils {
    public static String createStringTransferable(Session s, ResourceArray[] resources) throws DatabaseException {
        return ResourceTransferUtils.createStringTransferable(s, resources, null);
    }

    public static String createStringTransferable(Session s, ResourceArray[] resources, String purpose) throws DatabaseException {
        SerialisationSupport support = (SerialisationSupport)s.getService(SerialisationSupport.class);
        StringMemento memento = new StringMemento();
        ResourceTransferData transferData = new ResourceTransferData(s, resources);
        transferData.setPurpose(purpose);
        transferData.writeToMemento(support, (IMemento)memento);
        String strData = memento.toString();
        return strData;
    }

    public static String createStringTransferable(SerialisationSupport serializer, ResourceTransferData transferData) throws DatabaseException {
        StringMemento memento = new StringMemento();
        transferData.writeToMemento(serializer, (IMemento)memento);
        String strData = memento.toString();
        return strData;
    }

    public static Transferable createAwtTransferable(SerialisationSupport serializer, ResourceTransferData transferData) throws DatabaseException {
        String strData = ResourceTransferUtils.createStringTransferable(serializer, transferData);
        return new StringSelection(strData);
    }

    public static TransferData createSwtTextTransferData(SerialisationSupport serializer, ResourceTransferData transferable) throws DatabaseException {
        String strData = ResourceTransferUtils.createStringTransferable(serializer, transferable);
        TransferData transferData = new TransferData();
        TextTransfer.getInstance().javaToNative((Object)strData, transferData);
        return transferData;
    }

    public static ResourceTransferData readStringTransferable(SerialisationSupport serializer, String strData) throws IllegalArgumentException, DatabaseException {
        StringMemento sm = new StringMemento(strData);
        ResourceTransferData result = new ResourceTransferData();
        result.readFromMemento(serializer, (IMemento)sm);
        return result;
    }

    public static ResourceTransferData readAwtTransferable(SerialisationSupport serializer, Transferable transferable) throws UnsupportedFlavorException, IOException, IllegalArgumentException, DatabaseException {
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            throw new UnsupportedFlavorException(DataFlavor.stringFlavor);
        }
        String dropData = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        ResourceTransferData result = ResourceTransferUtils.readStringTransferable(serializer, dropData);
        return result;
    }

    public static ResourceTransferData readSwtTextTransferable(SerialisationSupport serializer, TransferData transferData) throws IOException, IllegalArgumentException, DatabaseException {
        if (!TextTransfer.getInstance().isSupportedType(transferData)) {
            throw new IllegalArgumentException("argument is not text transfer");
        }
        String dropData = TextTransfer.getInstance().nativeToJava(transferData).toString();
        ResourceTransferData result = ResourceTransferUtils.readStringTransferable(serializer, dropData);
        return result;
    }
}

