/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Tuukka Lehtonen
 */
public class WorkbenchShutdownServiceImpl implements WorkbenchShutdownService {

    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbenchShutdownServiceImpl.class);
    private static ServiceRegistration service = null;

    private final List<Runnable>       hooks   = new ArrayList<Runnable>();

    /**
     * Invoked by the bundle activator to initialize the cache service.
     * 
     * @param context the bundle context to register the service with
     */
    @SuppressWarnings({ "unchecked", "rawtypes" })
    public synchronized static void initialize(BundleContext context) {
        if (service == null) {
            service = context.registerService(WorkbenchShutdownService.class.getName(), new WorkbenchShutdownServiceImpl(), new Hashtable());
        }
    }

    /**
     * Invoked by the bundle activator to close the cache service.
     */
    public synchronized static void close() {
        if (service != null) {
            service.unregister();
            service = null;
        }
    }

    @Override
    public synchronized void registerShutdownHook(Runnable hook) {
        hooks.add(hook);
    }

    @Override
    public synchronized void doShutdown() {
        Runnable[] rs = hooks.toArray(new Runnable[0]);
        hooks.clear();
        for (Runnable hook : rs) {
            try {
                hook.run();
            } catch (Exception e) {
                handleException(hook, e);
            } catch (LinkageError e) {
                handleException(hook, e);
            } catch (AssertionError e) {
                handleException(hook, e);
            }
        }
    }

    protected void handleException(Object source, Throwable t) {
        LOGGER.error(getClass().getSimpleName() + ": workbench shutdown hook " + source + " caused unexpected exception:", t);
    }

}
