/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

public interface IPerspectiveContextExtension {

    String getPerspectiveId();

    String[] getContextIds();

    class Stub implements IPerspectiveContextExtension {
        String   perspectiveId;
        String[] contextIds;

        Stub(String perspectiveId, String[] contextIds) {
            this.perspectiveId = perspectiveId;
            this.contextIds = contextIds;
        }

        @Override
        public String[] getContextIds() {
            return contextIds;
        }

        @Override
        public String getPerspectiveId() {
            return perspectiveId;
        }
    }
}
