/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.simantics.internal.TimedSessionCache;
import org.simantics.ui.DoubleClickExtensionManager;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.PerspectiveBarsManager;
import org.simantics.ui.workbench.PerspectiveContextBindingManager;
import org.simantics.ui.workbench.editor.EditorRegistry;
import org.simantics.utils.ui.BundleUtils;


/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

    // The plug-in ID
    public static final String PLUGIN_ID = SimanticsUI.PLUGIN_ID;

    // The shared instance
    private static Activator plugin;
    
    /**
     * The constructor
     */
    public Activator() {
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;

        TimedSessionCache.initialize(context);

        // Initialize extension managers.
        // Disposed respectively in #stop().
        DoubleClickExtensionManager.getInstance();
        PerspectiveContextBindingManager.getInstance();
        PerspectiveBarsManager.getInstance();

        // Will be started when getInstance is first invoked.
        //ResourceEditorRegistry.getInstance();
        
        initializeDefaultPreferences(plugin.getPreferenceStore());
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
     */
    public void stop(BundleContext context) throws Exception {
        TimedSessionCache.close();

        plugin = null;

        // Dispose extension managers.
        EditorRegistry.dispose();

        PerspectiveContextBindingManager.dispose();
        PerspectiveBarsManager.dispose();
        DoubleClickExtensionManager.dispose();

        // Backup for disposing of the UI database session
        SimanticsUI.closeSessions();

        super.stop(context);
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }
    
    /**
     * Returns an image descriptor for the image file at the given
     * plug-in relative path.
     *
     * @param path the path
     * @return the image descriptor
     */
    public static ImageDescriptor getImageDescriptor(String path) {
        return BundleUtils.getImageDescriptorFromPlugin(PLUGIN_ID, path);
    }
    
    /** 
     * Initializes a preference store with default preference values 
     * for this plug-in.
     */
    protected void initializeDefaultPreferences(IPreferenceStore store) {
//        store.setDefault("showRequirements", true);
//        store.setDefault("hasStructuralModelling", true);
//        store.setDefault("showPropertyTypes", true);
//        store.setDefault("showAllowedChildren", true);
//        store.setDefault("showConnectionInterface", true);
//        store.setDefault("showDataInterface", true);
    }


}
