/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.internal;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.Preferences;
import org.simantics.AutosavePreferences;

/**
 * @author Tuukka Lehtonen <tuukka.lehtonen@semantum.fi>
 */
public class AutosavePreferenceInitializer extends AbstractPreferenceInitializer {

    public void initializeDefaultPreferences() {
        IScopeContext context = DefaultScope.INSTANCE;
        Preferences node = context.getNode(AutosavePreferences.P_NODE);
        node.putBoolean(AutosavePreferences.P_VG_AUTOSAVE_ENABLED, AutosavePreferences.DEFAULT_VG_AUTOSAVE_ENABLED);
        node.putInt(AutosavePreferences.P_VG_AUTOSAVE_INTERVAL, AutosavePreferences.DEFAULT_VG_AUTOSAVE_INTERVAL);
    }

}
