/*******************************************************************************
 * Copyright (c) 2025 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics;

/**
 * Indicates that the specified workspace is not compatible with the currently
 * running program version and that the program should therefore not be started.
 * 
 * @author Tuukka Lehtonen
 * @since 1.63.0
 * @see Workspaces
 */
public class UnsupportedWorkspaceVersionException extends PlatformException {

	private static final long serialVersionUID = 712004346430874213L;
	private final boolean fillStackTrace;

	public UnsupportedWorkspaceVersionException(String message) {
		super(message);
		fillStackTrace = false;
	}

	public UnsupportedWorkspaceVersionException(String message, Throwable cause) {
		super(message, cause);
		fillStackTrace = true;
	}

	@Override
	public synchronized Throwable fillInStackTrace() {
		if (fillStackTrace)
			return super.fillInStackTrace();
		return this;
	}

}