/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics;

import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;

/**
 * An Eclipse job that inherently belongs to the
 * {@link Simantics#DATABASE_JOB_FAMILY} job family.
 * 
 * <p>
 * Use {@link #inProgress()} to check whether there are currently any
 * {@link DatabaseJob}s running in the platform's job manager. Checks should be
 * performed if any synchronous database requests must be initiated in the UI
 * thread but it is not 100% necessary to return an accurate result right at
 * that moment. Performing too much synchronous requests in the UI thread will
 * currently inevitably get the UI completely stuck and therefore offloading
 * database work to database job worker threads is highly recommended.
 * 
 * @author Tuukka Lehtonen
 */
public abstract class DatabaseJob extends Job {

    public static final String DATABASE_JOB_FAMILY = "org.simantics.db.inDatabaseJob";

    public DatabaseJob(String name) {
        super(name);
    }

    @Override
    public boolean belongsTo(Object family) {
        if (DATABASE_JOB_FAMILY.equals(family))
            return true;
        return super.belongsTo(family);
    }

    public static boolean inProgress() {
        IJobManager manager = Job.getJobManager();
        Job[] jobs = manager.find(DATABASE_JOB_FAMILY);
        for (Job job : jobs)
            if (job.getState() == Job.RUNNING)
                return true;
        return false;
    }

}
