package org.simantics.scl.ui.imports;

import java.util.ArrayList;

import org.eclipse.swt.widgets.Shell;
import org.simantics.scl.compiler.commands.CommandSessionImportEntry;

public abstract class ImportModulesAction implements Comparable<ImportModulesAction> {
    public final String name;
    public final double priority;

    public ImportModulesAction(String name, double priority) {
        this.name = name;
        this.priority = priority;
    }

    public abstract boolean editImports(Shell shell,
            ArrayList<CommandSessionImportEntry> imports);
    
    @Override
    public int compareTo(ImportModulesAction o) {
        int cmp = Double.compare(priority, o.priority);
        if(cmp != 0)
            return cmp;
        return name.compareTo(o.name);
    }
}
