package org.simantics.scl.ui.editor2;

import java.io.IOException;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.TextualModuleSource;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;

public class SCLModuleEditor2DocumentProvider extends AbstractDocumentProvider {

    private SCLSourceViewerConfigurationNew sourceViewer;
    protected AnnotationModel annotationModel = new AnnotationModel();
    
    private Object currentElement;
    private TextualModuleSource currentSource;
    
    public SCLModuleEditor2DocumentProvider(SCLSourceViewerConfigurationNew sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    private void updateTextualModuleSource(Object input) {
        if (currentElement != null && currentElement.equals(input))
            return;
        currentElement = input;
        if(!(currentElement instanceof SCLModuleEditorInput))
            return;
        
        ModuleSource source = ((SCLModuleEditorInput)currentElement).getAdapter(ModuleSource.class);
        if(source == null)
            return;
        if(!(source instanceof TextualModuleSource))
            return;
        currentSource = (TextualModuleSource)source;
    }
    
    @Override
    protected IDocument createDocument(Object element) throws CoreException {
        updateTextualModuleSource(element);
        if(currentSource == null)
            throw new CoreException(
                    new Status(Status.ERROR, "org.simantics.scl.ui", Messages.SCLModuleEditor2DocumentProvider_Status_SCLSourceNotFound) //$NON-NLS-1$
                    );
        Document document;
        try {
            document = new Document(currentSource.getSourceText(null));
        } catch (IOException e) {
            throw new CoreException(
                    new Status(Status.ERROR, "org.simantics.scl.ui", "Reading SCL module failed.", e) //$NON-NLS-1$ //$NON-NLS-2$
                    );
        }
        SCLCodeHighlighting.connectPartitioner(document);
        sourceViewer.updateCompletionAssistModuleName(currentSource.getModuleName());
        return document;
    }
    
    @Override
    public void changed(Object element) {
        updateTextualModuleSource(element);
    }
    
    @Override
    public void aboutToChange(Object element) {
        super.aboutToChange(element);
    }
    
    @Override
    public boolean isModifiable(Object element) {
        if(currentSource == null)
            return false;
        return currentSource.isUpdateable();
    }
    
    @Override
    public boolean isReadOnly(Object element) {
        return !isModifiable(element);
    }

    @Override
    protected IAnnotationModel createAnnotationModel(Object element)
            throws CoreException {
        SCLModuleEditorInput input = (SCLModuleEditorInput)element;
        return new SCLAnnotationModel(input, SCLOsgi.MODULE_REPOSITORY);
    }

    @Override
    protected void doSaveDocument(IProgressMonitor monitor, Object element,
            IDocument document, boolean overwrite) throws CoreException {
        if(currentSource == null)
            return;
        currentSource.update(document.get());
    }

    @Override
    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        // TODO Auto-generated method stub
        return null;
    }

}
