package org.simantics.scl.ui.editor2;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

/**
 * @author Tuukka Lehtonen
 * @since 1.57.0 
 */
public class MatchingBracketHighlighting {

	private static final char[] CHARS = new char[] { '(', ')', '{', '}', '[', ']', '<', '>' };

	private static final String MATCHING_BRACKETS = "matchingBrackets"; //$NON-NLS-1$
	private static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor"; //$NON-NLS-1$
	private static final String HIGHLIGHT_BRACKET_AT_CARET_LOCATION = "highlightBracketAtCaretLocation"; //$NON-NLS-1$
	private static final String ENCLOSING_BRACKETS = "enclosingBrackets"; //$NON-NLS-1$

	public static DefaultCharacterPairMatcher configure(SourceViewerDecorationSupport support) {
		var matcher = new DefaultCharacterPairMatcher(CHARS);
		support.setCharacterPairMatcher(matcher);
		support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR, HIGHLIGHT_BRACKET_AT_CARET_LOCATION, ENCLOSING_BRACKETS);
		return matcher;
	}

	public static void setDefaultPreferences(IPreferenceStore p) {
		p.setValue(MATCHING_BRACKETS, true);
		p.setValue(MATCHING_BRACKETS_COLOR, "192,192,192"); //$NON-NLS-1$
		p.setValue(HIGHLIGHT_BRACKET_AT_CARET_LOCATION, true);
		p.setValue(ENCLOSING_BRACKETS, true);
	}

}