package org.simantics.scl.ui.editor2;


import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.module.InvalidModulePathException;
import org.simantics.scl.compiler.module.ModuleUtils;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.editor.completion.SCLTextEditorEnvironment;
import org.simantics.scl.ui.search.SCLSearchQuery;

public class FindSCLSearchAction extends AbstractHandler {

    private static boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c) || c=='.';
    }
    
    private static String extractIdentifierAt(String text, int caretPos) {
        int startPos = caretPos;
        while(startPos > 0 && isIdentifierPart(text.charAt(startPos-1)))
            --startPos;
        int endPos = caretPos;
        while(endPos < text.length() && isIdentifierPart(text.charAt(endPos)))
            ++endPos;
        return text.substring(startPos, endPos);
    }
    
    private static final String SYMBOL_CHARS = "!$%&*+/<=>?@\\^|-:~."; //$NON-NLS-1$
    
    private static boolean isSymbolPart(char c) {
        for(int i=0;i<SYMBOL_CHARS.length();++i)
            if(SYMBOL_CHARS.charAt(i) == c)
                return true;
        return false;
    }
    
    private static String extractSymbolAt(String text, int caretPos) {
        int startPos = caretPos;
        while(startPos > 0 && isSymbolPart(text.charAt(startPos-1)))
            --startPos;
        int endPos = caretPos;
        while(endPos < text.length() && isSymbolPart(text.charAt(endPos)))
            ++endPos;
        return text.substring(startPos, endPos);
    }
    
    public static String extractIdentifierOrSymbolAt(String text, int caretPos) {
        String result = extractIdentifierAt(text, caretPos);
        if(!result.isEmpty())
            return result;
        return extractSymbolAt(text, caretPos);
    }
    
    private static String extractLineAt(String text, int caretPos) {
        int startPos = caretPos;
        while(startPos > 0 && !isNewline(text.charAt(startPos-1)))
            --startPos;
        int endPos = caretPos;
        while(endPos < text.length() && !isNewline(text.charAt(endPos)))
            ++endPos;
        return text.substring(startPos, endPos);
    }
    
    private static boolean isNewline(char c) {
        return c=='\n' || c=='\r';
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = 
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if(!(editor instanceof SCLModuleEditor2))
            return null;
        SCLModuleEditor2 moduleEditor = (SCLModuleEditor2)editor;
        StyledText styledText = (StyledText)moduleEditor.getAdapter(Control.class);
        String text = styledText.getText();
        int caretOffset = styledText.getCaretOffset();
        
        // Find the line where the caret is
//        String lineAtCaret = extractLineAt(text, caretOffset);
        // Try to find an identifier at caret
        String identifierAtCaret = extractIdentifierOrSymbolAt(text, caretOffset);
        if(identifierAtCaret.isEmpty())
            return null;
        SCLModuleEditorInput input = (SCLModuleEditorInput)moduleEditor.getEditorInput();
        String localModuleName = input.getModuleName();
        
        SCLTextEditorEnvironment editorEnvironment = moduleEditor.getSCLTextEditorEnvironment();
        editorEnvironment.updateEnvironment(moduleEditor.getDocument());
        SCLValue value = editorEnvironment.getValue(identifierAtCaret);
        Name name;
        if (value == null) {
            name = Name.create(localModuleName, identifierAtCaret);
        } else {
            name = value.getName();
        }
        SCLSearchQuery query = new SCLSearchQuery(name, localModuleName);
        NewSearchUI.runQueryInBackground(query);
            
            
            
//            SCLTextEditorEnvironment editorEnvironment = moduleEditor.getSCLTextEditorEnvironment();
//            editorEnvironment.updateEnvironment(moduleEditor.getDocument());
//            SCLValue value = editorEnvironment.getValue(identifierAtCaret);
//            //System.out.println("identifierAtCaret = " + identifierAtCaret + " [" + Locations.beginOf(value.definitionLocation) + ", " + Locations.endOf(value.definitionLocation) + "]");
//            if(value != null)
//                OpenSCLDefinition.openDefinition(value);
        return null;
    }

}
