package org.simantics.scl.ui.editor;

import gnu.trove.map.hash.THashMap;

import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

final public class SharedTextColorsNew implements ISharedTextColors {

    Display display;
    THashMap<RGB,Color> map = new THashMap<RGB,Color>();
    
    public SharedTextColorsNew(Display display) {
        this.display = display;
    }

    @Override
    public Color getColor(RGB rgb) {
        Color color = map.get(rgb);
        if(color == null) {
            color = new Color(display, rgb);
            map.put(rgb, color);
        }
        return color;
    }

    @Override
    public void dispose() {
        for(Color color : map.values())
            color.dispose();
        map.clear();
    }
}