/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.reporting;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.reporting.DelegatingSCLReportingHandler;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLReporting {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLReporting.class);

    public static SCLReportingHandler getCurrentReportingHandler() {
        SCLReportingHandler handler = (SCLReportingHandler)SCLContext.getCurrent().get("reportingHandler");
        return handler == null ? SCLReportingHandler.DEFAULT : handler;
    }

    public static void print(String text) {
        SCLReportingHandler handler = (SCLReportingHandler)SCLContext.getCurrent().get("reportingHandler");
        if (handler != null) {
            handler.print(text);
        } else {
            System.out.println(text);
        }
    }

    public static void printError(String text) {
        SCLReportingHandler handler = (SCLReportingHandler)SCLContext.getCurrent().get("reportingHandler");
        if (handler != null) {
            handler.printError(text);
        } else {
            LOGGER.error(text);
        }
    }

    public static void didWork(double amount) {
        SCLReportingHandler handler = (SCLReportingHandler)SCLContext.getCurrent().get("reportingHandler");
        if (handler != null) {
            handler.didWork(amount);
        }
    }

    public static Object printingToFile(String fileName, Charset charset, Function proc) throws IOException {
        SCLContext context = SCLContext.getCurrent();
        Object oldHandler = context.get("reportingHandler");
        FileWriter writer = new FileWriter(fileName, charset);
        context.put("reportingHandler", new FileReportingHandler(oldHandler == null ? SCLReportingHandler.DEFAULT : (SCLReportingHandler)oldHandler, writer));
        try {
            Object r;
            block13: {
                Throwable throwable = null;
                Object var7_8 = null;
                FileWriter w = writer;
                try {
                    r = proc.apply(Tuple0.INSTANCE);
                    if (w == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        if (w != null) {
                            w.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                w.close();
            }
            return r;
        }
        finally {
            context.put("reportingHandler", oldHandler);
        }
    }

    public static Object printingToFile(String fileName, String charset, Function proc) throws IOException {
        return SCLReporting.printingToFile(fileName, Charset.forName(charset), proc);
    }

    public static Object printingToFile(String fileName, Function proc) throws IOException {
        return SCLReporting.printingToFile(fileName, StandardCharsets.UTF_8, proc);
    }

    public static Object printErrorsAsNormalPrints(Function proc) {
        SCLContext context = SCLContext.getCurrent();
        SCLReportingHandler handler = (SCLReportingHandler)context.get("reportingHandler");
        if (handler == null) {
            handler = SCLReportingHandler.DEFAULT;
        }
        context.put("reportingHandler", new DelegatingSCLReportingHandler(handler){

            @Override
            public void printError(String error) {
                this.print(error);
            }
        });
        try {
            Object r = proc.apply(Tuple0.INSTANCE);
            return r;
        }
        finally {
            context.put("reportingHandler", handler);
        }
    }

    public static Object disablePrintingForCommand(Function proc) {
        SCLContext context = SCLContext.getCurrent();
        SCLReportingHandler handler = (SCLReportingHandler)context.get("reportingHandler");
        if (handler == null) {
            handler = SCLReportingHandler.DEFAULT;
        }
        context.put("reportingHandler", new DelegatingSCLReportingHandler(handler){

            @Override
            public void print(String text) {
            }
        });
        try {
            Object r = proc.apply(Tuple0.INSTANCE);
            return r;
        }
        finally {
            context.put("reportingHandler", handler);
        }
    }

    public static Object printingToLogging(Function proc) {
        SCLContext context = SCLContext.getCurrent();
        SCLReportingHandler handler = (SCLReportingHandler)context.get("reportingHandler");
        if (handler == null) {
            handler = SCLReportingHandler.DEFAULT;
        }
        context.put("reportingHandler", SCLReportingHandler.DEFAULT);
        try {
            Object r = proc.apply(Tuple0.INSTANCE);
            return r;
        }
        finally {
            context.put("reportingHandler", handler);
        }
    }

    private static class FileReportingHandler
    extends DelegatingSCLReportingHandler {
        FileWriter writer;

        public FileReportingHandler(SCLReportingHandler baseHandler, FileWriter writer) {
            super(baseHandler);
            this.writer = writer;
        }

        @Override
        public void print(String text) {
            try {
                this.writer.append(text);
                this.writer.append('\n');
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

