/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.generation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;

public class GenerateFunctions {
    public static final String PACKAGE = "org.simantics.scl.runtime.function";
    public static final int MAX_ARITY = 8;
    public static final String HEADER = "/**\r\n * This code is generated in " + GenerateFunctions.class.getName() + ".\r\n * Do not edit manually!\r\n */";

    public static void generateFunctionN(PrintStream p, int n) {
        p.println(HEADER);
        p.println("package org.simantics.scl.runtime.function;");
        p.println();
        p.print("public interface Function" + n + "<");
        int i = 0;
        while (i < n) {
            p.print("P" + i + ",");
            ++i;
        }
        p.println("R> {");
        p.print("    R apply(");
        i = 0;
        while (i < n) {
            if (i > 0) {
                p.print(", ");
            }
            p.print("P" + i + " p" + i);
            ++i;
        }
        p.println(");");
        p.println("}");
    }

    public static void generateFunctionN(PrintStream p) {
        p.println(HEADER);
        p.println("package org.simantics.scl.runtime.function;");
        p.println();
        p.println("public interface FunctionN {");
        p.println("    Object applyArray(Object ... ps);");
        p.println("}");
    }

    public static void generateFunction(PrintStream p) {
        p.println(HEADER);
        p.println("package org.simantics.scl.runtime.function;");
        p.println();
        p.print("public interface Function<");
        int k = 0;
        while (k < 8) {
            p.print("P" + k + ",");
            ++k;
        }
        k = 1;
        while (k <= 8) {
            p.print("R" + k);
            if (k < 8) {
                p.print(",");
            }
            ++k;
        }
        p.println("> extends");
        k = 1;
        while (k <= 8) {
            p.print("    Function" + k + "<");
            int i = 0;
            while (i < k) {
                p.print("P" + i + ",");
                ++i;
            }
            p.println("R" + k + ">,");
            ++k;
        }
        p.println("    FunctionN {");
        p.println("}");
    }

    public static void generateFunctionImplN(PrintStream p, int n) {
        int i;
        p.println(HEADER);
        p.println("package org.simantics.scl.runtime.function;");
        p.println();
        p.println("import java.util.Arrays;");
        p.println();
        p.println("@SuppressWarnings(\"all\")");
        p.print("public abstract class FunctionImpl" + n + "<");
        int i2 = 0;
        while (i2 < n) {
            p.print("P" + i2 + ",");
            ++i2;
        }
        p.print("R> implements Function<");
        i2 = 0;
        while (i2 < n) {
            p.print("P" + i2 + ",");
            ++i2;
        }
        i2 = n;
        while (i2 < 8) {
            p.print("Object,");
            ++i2;
        }
        i2 = 1;
        while (i2 <= 8) {
            if (i2 == n) {
                p.print("R");
            } else {
                p.print("Object");
            }
            if (i2 < 8) {
                p.print(",");
            }
            ++i2;
        }
        p.println("> {");
        int k = 1;
        while (k < Math.min(n, 9)) {
            p.println("    @Override");
            p.print("    public Object apply(");
            i = 0;
            while (i < k) {
                if (i > 0) {
                    p.print(", ");
                }
                p.print("Object p" + i);
                ++i;
            }
            p.println(") {");
            p.print("        return new UnsaturatedFunction" + k + "(this");
            i = 0;
            while (i < k) {
                p.print(", p" + i);
                ++i;
            }
            p.println(");");
            p.println("    }");
            p.println();
            ++k;
        }
        if (n <= 8) {
            p.println("    @Override");
        }
        p.print("    public abstract R apply(");
        i2 = 0;
        while (i2 < n) {
            if (i2 > 0) {
                p.print(", ");
            }
            p.print("P" + i2 + " p" + i2);
            ++i2;
        }
        p.println(");");
        p.println();
        k = n + 1;
        while (k <= 8) {
            p.println("    @Override");
            p.print("    public Object apply(");
            i = 0;
            while (i < k) {
                if (i > 0) {
                    p.print(", ");
                }
                p.print("Object p" + i);
                ++i;
            }
            p.println(") {");
            p.println("        try {");
            p.print("            return ((Function)apply(");
            i = 0;
            while (i < n) {
                if (i > 0) {
                    p.print(", ");
                }
                p.print("(P" + i + ")p" + i);
                ++i;
            }
            p.print(")).apply(");
            i = n;
            while (i < k) {
                if (i > n) {
                    p.print(", ");
                }
                p.print("p" + i);
                ++i;
            }
            p.println(");");
            p.println("        } catch(ClassCastException e) {");
            p.println("            throw new CalledWithTooManyParameters();");
            p.println("        }");
            p.println("    }");
            p.println();
            ++k;
        }
        p.println("    @Override");
        p.println("    public Object applyArray(Object ... ps) {");
        p.println("        switch(ps.length) {");
        k = 0;
        while (k <= 8 + n) {
            p.println("        case " + k + ":");
            if (k == 0) {
                p.println("            return this;");
            } else if (k < n) {
                p.print("            return new UnsaturatedFunction" + k + "(this");
                i = 0;
                while (i < k) {
                    p.print(", ps[" + i + "]");
                    ++i;
                }
                p.println(");");
            } else if (k == n) {
                p.print("            return apply(");
                i = 0;
                while (i < k) {
                    if (i > 0) {
                        p.print(", ");
                    }
                    p.print("(P" + i + ")ps[" + i + "]");
                    ++i;
                }
                p.println(");");
            } else if (k <= n + 8) {
                p.println("            try {");
                p.print("                return ((Function)apply(");
                i = 0;
                while (i < n) {
                    if (i > 0) {
                        p.print(", ");
                    }
                    p.print("(P" + i + ")ps[" + i + "]");
                    ++i;
                }
                p.print(")).apply(");
                i = n;
                while (i < k) {
                    if (i > n) {
                        p.print(", ");
                    }
                    p.print("ps[" + i + "]");
                    ++i;
                }
                p.println(");");
                p.println("            } catch(ClassCastException e) {");
                p.println("                throw new CalledWithTooManyParameters();");
                p.println("            }");
            }
            ++k;
        }
        p.println("        default:");
        p.println("            try {");
        p.print("                return ((Function)apply(");
        i2 = 0;
        while (i2 < n) {
            if (i2 > 0) {
                p.print(", ");
            }
            p.print("(P" + i2 + ")ps[" + i2 + "]");
            ++i2;
        }
        p.println(")).apply(Arrays.copyOfRange(ps, " + n + ", ps.length));");
        p.println("            } catch(ClassCastException e) {");
        p.println("                throw new CalledWithTooManyParameters();");
        p.println("            }");
        p.println("        }");
        p.println("    }");
        p.println("}");
    }

    public static void generateFunctionImplN(PrintStream p) {
        p.println(HEADER);
        p.println("package org.simantics.scl.runtime.function;");
        p.println();
        p.println("import java.util.Arrays;");
        p.println();
        p.println("@SuppressWarnings(\"all\")");
        p.println("public abstract class FunctionImplN implements Function {");
        p.println("    int arity;");
        p.println();
        p.println("    public FunctionImplN(int arity) {");
        p.println("        if(arity < 1)");
        p.println("            throw new IllegalArgumentException();");
        p.println("        this.arity = arity;");
        p.println("    }");
        p.println();
        int k = 1;
        while (k <= 8) {
            p.println("    @Override");
            p.print("    public Object apply(");
            int i = 0;
            while (i < k) {
                if (i > 0) {
                    p.print(", ");
                }
                p.print("Object p" + i);
                ++i;
            }
            p.println(") {");
            p.println("        try {");
            p.println("            switch(arity) {");
            i = 1;
            while (i < k) {
                p.print("            case " + i + ": return ((Function)doApply(");
                int j = 0;
                while (j < i) {
                    if (j > 0) {
                        p.print(", ");
                    }
                    p.print("p" + j);
                    ++j;
                }
                p.print(")).apply(");
                j = i;
                while (j < k) {
                    if (j > i) {
                        p.print(", ");
                    }
                    p.print("p" + j);
                    ++j;
                }
                p.println(");");
                ++i;
            }
            p.print("            case " + k + ": return doApply(");
            i = 0;
            while (i < k) {
                if (i > 0) {
                    p.print(", ");
                }
                p.print("p" + i);
                ++i;
            }
            p.println(");");
            p.print("            default: return new UnsaturatedFunction" + k + "(this");
            i = 0;
            while (i < k) {
                p.print(", p" + i);
                ++i;
            }
            p.println(");");
            p.println("            }");
            p.println("        } catch(ClassCastException e) {");
            p.println("            throw new CalledWithTooManyParameters();");
            p.println("        }");
            p.println("    }");
            p.println();
            ++k;
        }
        p.println("    public abstract Object doApply(Object ... ps);");
        p.println();
        p.println("    @Override");
        p.println("    public Object applyArray(Object ... ps) {");
        p.println("        if(ps.length == arity)");
        p.println("            return doApply(ps);");
        p.println("        else if(ps.length < arity)");
        p.println("            return new UnsaturatedFunctionN(this, ps);");
        p.println("        else /* ps.length > arity */ {");
        p.println("            try {");
        p.println("                return ((Function)doApply(Arrays.copyOf(ps, arity))).applyArray(Arrays.copyOfRange(ps, arity, ps.length));");
        p.println("            } catch(ClassCastException e) {");
        p.println("                throw new CalledWithTooManyParameters();");
        p.println("            }");
        p.println("        }");
        p.println("    }");
        p.println("}");
    }

    public static void generateUnsaturatedFunctionN(PrintStream p, int n) {
        p.println(HEADER);
        p.println("package org.simantics.scl.runtime.function;");
        p.println();
        p.println("@SuppressWarnings(\"all\")");
        p.println("public class UnsaturatedFunction" + n + " implements Function {");
        p.println("    private final Function f;");
        int i = 0;
        while (i < n) {
            p.println("    private final Object p" + i + ";");
            ++i;
        }
        p.println();
        p.print("    public UnsaturatedFunction" + n + "(Function f");
        i = 0;
        while (i < n) {
            p.print(", Object p" + i);
            ++i;
        }
        p.println(") {");
        p.println("        this.f = f;");
        i = 0;
        while (i < n) {
            p.println("        this.p" + i + " = p" + i + ";");
            ++i;
        }
        p.println("    }");
        p.println();
        int k = 1;
        while (k <= 8) {
            p.println("    @Override");
            p.print("    public Object apply(");
            int i2 = 0;
            while (i2 < k) {
                if (i2 > 0) {
                    p.print(", ");
                }
                p.print("Object p" + (i2 + n));
                ++i2;
            }
            p.println(") {");
            if (n + k <= 8) {
                p.print("        return f.apply(");
            } else {
                p.print("        return f.applyArray(");
            }
            i2 = 0;
            while (i2 < k + n) {
                if (i2 > 0) {
                    p.print(", ");
                }
                p.print("p" + i2);
                ++i2;
            }
            p.println(");");
            p.println("    }");
            p.println();
            ++k;
        }
        p.println("    @Override");
        p.println("    public Object applyArray(Object ... ps) {");
        p.println("        Object[] nps = new Object[ps.length + " + n + "];");
        i = 0;
        while (i < n) {
            p.println("        nps[" + i + "] = p" + i + ";");
            ++i;
        }
        p.println("        for(int i=0;i<ps.length;++i)");
        p.println("            nps[i + " + n + "] = ps[i];");
        p.println("        return f.applyArray(nps);");
        p.println("    }");
        p.println();
        p.println("    @Override");
        p.println("    public String toString() {");
        p.println("        StringBuilder sb = new StringBuilder();");
        p.println("        sb.append(\"(\").append(f);");
        i = 0;
        while (i < n) {
            p.println("        sb.append(\" \").append(p" + i + ");");
            ++i;
        }
        p.println("        sb.append(\")\");");
        p.println("        return sb.toString();");
        p.println("    }");
        p.println();
        p.println("    @Override");
        p.println("    public int hashCode() {");
        p.println("        int result = f.hashCode();");
        i = 0;
        while (i < n) {
            p.println("        result = 31 * result + (p" + i + " == null ? 0 : p" + i + ".hashCode());");
            ++i;
        }
        p.println("        return result;");
        p.println("    }");
        p.println();
        p.println("    @Override");
        p.println("    public boolean equals(Object obj) {");
        p.println("        if (this == obj)");
        p.println("            return true;");
        p.println("        if (obj == null)");
        p.println("            return false;");
        p.println("        if (getClass() != obj.getClass())");
        p.println("            return false;");
        p.println("        UnsaturatedFunction" + n + " other = (UnsaturatedFunction" + n + ") obj;");
        p.println("        if(!f.equals(other.f))");
        p.println("            return false;");
        i = 0;
        while (i < n) {
            p.println("        if(p" + i + " == null) {");
            p.println("            if (other.p" + i + " != null)");
            p.println("                return false;");
            p.println("        } else if (!p" + i + ".equals(other.p" + i + "))");
            p.println("            return false;");
            ++i;
        }
        p.println("        return true;");
        p.println("    }");
        p.println();
        p.println("}");
    }

    public static void generateUnsaturatedFunctionN(PrintStream p) {
        p.println(HEADER);
        p.println("package org.simantics.scl.runtime.function;");
        p.println();
        p.println("import java.util.Arrays;");
        p.println();
        p.println("@SuppressWarnings(\"all\")");
        p.println("public class UnsaturatedFunctionN implements Function {");
        p.println("    private final Function f;");
        p.println("    private final Object[] ps;");
        p.println();
        p.println("    public UnsaturatedFunctionN(Function f, Object ... ps) {");
        p.println("        this.f = f;");
        p.println("        this.ps = ps;");
        p.println("    }");
        p.println();
        int k = 1;
        while (k <= 8) {
            p.println("    @Override");
            p.print("    public Object apply(");
            int i = 1;
            while (i <= k) {
                if (i > 1) {
                    p.print(", ");
                }
                p.print("Object p" + i);
                ++i;
            }
            p.println(") {");
            p.println("        Object[] nps = new Object[ps.length + " + k + "];");
            p.println("        System.arraycopy(ps, 0, nps, 0, ps.length);");
            i = 1;
            while (i <= k) {
                p.println("        nps[ps.length+" + (i - 1) + "] = p" + i + ";");
                ++i;
            }
            p.println("        return f.applyArray(nps);");
            p.println("    }");
            p.println();
            ++k;
        }
        p.println("    @Override");
        p.println("    public Object applyArray(Object ... ops) {");
        p.println("        Object[] nps = new Object[ps.length + ops.length];");
        p.println("        System.arraycopy(ps, 0, nps, 0, ps.length);");
        p.println("        System.arraycopy(ops, 0, nps, ps.length, ops.length);");
        p.println("        return f.applyArray(nps);");
        p.println("    }");
        p.println();
        p.println("    @Override");
        p.println("    public String toString() {");
        p.println("        StringBuilder sb = new StringBuilder();");
        p.println("        sb.append(\"(\").append(f);");
        p.println("        for (Object p : ps)");
        p.println("            sb.append(\" \").append(p);");
        p.println("        sb.append(\")\");");
        p.println("        return sb.toString();");
        p.println("    }");
        p.println();
        p.println("    @Override");
        p.println("    public int hashCode() {");
        p.println("        return f.hashCode() + 31 * Arrays.hashCode(ps);");
        p.println("    }");
        p.println();
        p.println("    @Override");
        p.println("    public boolean equals(Object obj) {");
        p.println("        if (this == obj)");
        p.println("            return true;");
        p.println("        if (obj == null)");
        p.println("            return false;");
        p.println("        if (getClass() != obj.getClass())");
        p.println("            return false;");
        p.println("        UnsaturatedFunctionN other = (UnsaturatedFunctionN) obj;");
        p.println("        return f.equals(other.f) && Arrays.equals(ps, other.ps);");
        p.println("    }");
        p.println();
        p.println("}");
    }

    public static void main(String[] args) throws Exception {
        PrintStream ps;
        URL url = GenerateFunctions.class.getResource(".");
        File dir = new File(url.getPath());
        while (!new File(dir, "src").exists()) {
            dir = dir.getParentFile();
        }
        dir = new File(dir, "src");
        dir = new File(dir, PACKAGE.replace('.', '/'));
        dir.mkdirs();
        int n = 1;
        while (n <= 8) {
            ps = new PrintStream(new FileOutputStream(new File(dir, "Function" + n + ".java")));
            GenerateFunctions.generateFunctionN(ps, n);
            ++n;
        }
        PrintStream ps2 = new PrintStream(new FileOutputStream(new File(dir, "FunctionN.java")));
        GenerateFunctions.generateFunctionN(ps2);
        ps2 = new PrintStream(new FileOutputStream(new File(dir, "Function.java")));
        GenerateFunctions.generateFunction(ps2);
        n = 1;
        while (n <= 8) {
            ps = new PrintStream(new FileOutputStream(new File(dir, "FunctionImpl" + n + ".java")));
            GenerateFunctions.generateFunctionImplN(ps, n);
            ++n;
        }
        ps = new PrintStream(new FileOutputStream(new File(dir, "FunctionImplN.java")));
        GenerateFunctions.generateFunctionImplN(ps);
        n = 1;
        while (n <= 8) {
            ps = new PrintStream(new FileOutputStream(new File(dir, "UnsaturatedFunction" + n + ".java")));
            GenerateFunctions.generateUnsaturatedFunctionN(ps, n);
            ++n;
        }
        ps = new PrintStream(new FileOutputStream(new File(dir, "UnsaturatedFunctionN.java")));
        GenerateFunctions.generateUnsaturatedFunctionN(ps);
    }
}

