/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.commands.TestScriptExecutor;
import org.simantics.scl.compiler.testing.TestRunnable;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

public class BundleTestScriptRunnable
implements TestRunnable {
    private final String name;
    private final URL url;

    public BundleTestScriptRunnable(String name, URL url) {
        this.name = name;
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void run() throws Exception {
        InputStream stream = this.url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        SCLContext context = SCLContext.getCurrent();
        SCLReportingHandler printer = (SCLReportingHandler)context.get((Object)"reportingHandler");
        SCLReportingHandler handler = printer instanceof SCLReportingHandler ? printer : SCLReportingHandler.DEFAULT;
        try {
            CommandSession session = new CommandSession(SCLOsgi.MODULE_REPOSITORY, handler);
            new TestScriptExecutor(session, reader, handler).execute();
        }
        finally {
            reader.close();
        }
    }

    public String toString() {
        return this.getName() + " (" + String.valueOf(this.url) + ")";
    }
}

