package org.simantics.scl.osgi.internal;

import java.io.File;
import java.util.Collection;
import java.util.Collections;

import org.osgi.service.component.annotations.Component;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.FileModuleSource;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.TextualModuleSource;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;

import gnu.trove.procedure.TObjectProcedure;

@Component
public class FileSystemModuleSourceRepository implements ModuleSourceRepository {
    @Override
    synchronized public ModuleSource getModuleSource(String moduleName,
            UpdateListener listener) {
        if(!moduleName.startsWith("file:"))
            return null;
        return new FileModuleSource(moduleName, getClass().getClassLoader(), 
                new File(moduleName.substring(5)), TextualModuleSource.DEFAULT_IMPORTS);
    }

    @Override
    public Collection<String> getModuleNames() {
        return Collections.emptyList();
    }
    
    @Override
    public void forAllModules(TObjectProcedure<String> procedure) {
    }
    
}
