/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scl.db;

import java.io.IOException;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.Resource;
import org.simantics.db.request.QueryFactoryKey;
import org.simantics.db.request.QuerySerializer;
import org.simantics.scl.runtime.function.Function;

public class SubqueryRVariant extends SubqueryR<Variant> {

	@SuppressWarnings("rawtypes")
	public SubqueryRVariant(Resource r, Function f) {
		super(r, id(f));
	}

	public SubqueryRVariant(Resource r, String id) {
		super(r, id);
	}

	public static Serializer VARIANT_SERIALIZER = Bindings.getSerializerUnchecked(Bindings.VARIANT);

	@Override
	public void serializeValue(QuerySerializer serializer, Variant value) {

		try {
			byte[] bytes = VARIANT_SERIALIZER.serialize(value);
			serializer.addBytes(bytes);
		} catch (IOException e) {
			throw new IllegalStateException(e);
		}

	}

	private static final QueryFactoryKey queryFactoryKey = new QueryFactoryKey("org.simantics.scl.db", SubqueryRVariant.class.getName()); 

	@Override
	public QueryFactoryKey classId() {
		return queryFactoryKey;
	}

}