/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy  - initial API and implementation
 *******************************************************************************/
package org.simantics.scl.db;

import java.util.ArrayList;

import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.QueryDeserializer;
import org.simantics.db.request.QueryFactory;

public class SubqueryRStatementListFactory implements QueryFactory {

	@Override
	public Object readValue(QueryDeserializer deserializer, Object key) throws DatabaseException {
		int size = deserializer.readLE4();
		ArrayList<Statement> value = new ArrayList<>();
		for(int i=0;i<size;i++) {
			Statement stm = deserializer.readStatement();
			value.add(stm);
		}
		return value;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T readKey(QueryDeserializer deserializer) throws DatabaseException {
		Resource r = deserializer.readResource();
		String id = deserializer.readString();
		return (T)new SubqueryRStatementList(r, id);
	}

}
