/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scl.db;

import java.util.List;

import org.simantics.db.Resource;
import org.simantics.db.request.QueryFactoryKey;
import org.simantics.db.request.QuerySerializer;
import org.simantics.scl.runtime.function.Function;

public class SubqueryRResourceList extends SubqueryR<List<Resource>> {

	@SuppressWarnings("rawtypes")
	public SubqueryRResourceList(Resource r, Function f) {
		super(r, id(f));
	}

	public SubqueryRResourceList(Resource r, String id) {
		super(r, id);
	}

	@Override
	public void serializeValue(QuerySerializer serializer, List<Resource> value) {
		serializer.addLE4(value.size());
		for(Resource r : value) {
			serializer.addResource(r);
		}
	}

	private static final QueryFactoryKey queryFactoryKey = new QueryFactoryKey("org.simantics.scl.db", SubqueryRResourceList.class.getName()); 

	@Override
	public QueryFactoryKey classId() {
		return queryFactoryKey;
	}

}